/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import com.google.common.primitives.Longs;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.CryptoInputStream;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.crypto.JceAesCtrCryptoCodec;
import org.apache.hadoop.crypto.OpensslCipher;
import org.apache.hadoop.crypto.TestCryptoStreams;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.RandomDatum;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestCryptoCodec {
    private static final Log LOG = LogFactory.getLog(TestCryptoCodec.class);
    private static byte[] key = new byte[16];
    private static byte[] iv = new byte[16];
    private static final int bufferSize = 4096;
    private Configuration conf = new Configuration();
    private int count = 10000;
    private int seed = new Random().nextInt();
    private final String jceCodecClass = "org.apache.hadoop.crypto.JceAesCtrCryptoCodec";
    private final String opensslCodecClass = "org.apache.hadoop.crypto.OpensslAesCtrCryptoCodec";

    @Before
    public void setUp() throws IOException {
        SecureRandom random = new SecureRandom();
        ((Random)random).nextBytes(key);
        ((Random)random).nextBytes(iv);
    }

    @Test(timeout=120000L)
    public void testJceAesCtrCryptoCodec() throws Exception {
        if (!"true".equalsIgnoreCase(System.getProperty("runningWithNative"))) {
            LOG.warn((Object)"Skipping since test was not run with -Pnative flag");
            Assume.assumeTrue((boolean)false);
        }
        if (!NativeCodeLoader.buildSupportsOpenssl()) {
            LOG.warn((Object)"Skipping test since openSSL library not loaded");
            Assume.assumeTrue((boolean)false);
        }
        Assert.assertEquals(null, (Object)OpensslCipher.getLoadingFailureReason());
        this.cryptoCodecTest(this.conf, this.seed, 0, "org.apache.hadoop.crypto.JceAesCtrCryptoCodec", "org.apache.hadoop.crypto.JceAesCtrCryptoCodec", iv);
        this.cryptoCodecTest(this.conf, this.seed, this.count, "org.apache.hadoop.crypto.JceAesCtrCryptoCodec", "org.apache.hadoop.crypto.JceAesCtrCryptoCodec", iv);
        this.cryptoCodecTest(this.conf, this.seed, this.count, "org.apache.hadoop.crypto.JceAesCtrCryptoCodec", "org.apache.hadoop.crypto.OpensslAesCtrCryptoCodec", iv);
        for (int i = 0; i < 8; ++i) {
            TestCryptoCodec.iv[8 + i] = -1;
        }
        this.cryptoCodecTest(this.conf, this.seed, this.count, "org.apache.hadoop.crypto.JceAesCtrCryptoCodec", "org.apache.hadoop.crypto.JceAesCtrCryptoCodec", iv);
        this.cryptoCodecTest(this.conf, this.seed, this.count, "org.apache.hadoop.crypto.JceAesCtrCryptoCodec", "org.apache.hadoop.crypto.OpensslAesCtrCryptoCodec", iv);
    }

    @Test(timeout=120000L)
    public void testOpensslAesCtrCryptoCodec() throws Exception {
        if (!"true".equalsIgnoreCase(System.getProperty("runningWithNative"))) {
            LOG.warn((Object)"Skipping since test was not run with -Pnative flag");
            Assume.assumeTrue((boolean)false);
        }
        if (!NativeCodeLoader.buildSupportsOpenssl()) {
            LOG.warn((Object)"Skipping test since openSSL library not loaded");
            Assume.assumeTrue((boolean)false);
        }
        Assert.assertEquals(null, (Object)OpensslCipher.getLoadingFailureReason());
        this.cryptoCodecTest(this.conf, this.seed, 0, "org.apache.hadoop.crypto.OpensslAesCtrCryptoCodec", "org.apache.hadoop.crypto.OpensslAesCtrCryptoCodec", iv);
        this.cryptoCodecTest(this.conf, this.seed, this.count, "org.apache.hadoop.crypto.OpensslAesCtrCryptoCodec", "org.apache.hadoop.crypto.OpensslAesCtrCryptoCodec", iv);
        this.cryptoCodecTest(this.conf, this.seed, this.count, "org.apache.hadoop.crypto.OpensslAesCtrCryptoCodec", "org.apache.hadoop.crypto.JceAesCtrCryptoCodec", iv);
        for (int i = 0; i < 8; ++i) {
            TestCryptoCodec.iv[8 + i] = -1;
        }
        this.cryptoCodecTest(this.conf, this.seed, this.count, "org.apache.hadoop.crypto.OpensslAesCtrCryptoCodec", "org.apache.hadoop.crypto.OpensslAesCtrCryptoCodec", iv);
        this.cryptoCodecTest(this.conf, this.seed, this.count, "org.apache.hadoop.crypto.OpensslAesCtrCryptoCodec", "org.apache.hadoop.crypto.JceAesCtrCryptoCodec", iv);
    }

    private void cryptoCodecTest(Configuration conf, int seed, int count, String encCodecClass, String decCodecClass, byte[] iv) throws IOException, GeneralSecurityException {
        int expected;
        CryptoCodec encCodec = null;
        try {
            encCodec = (CryptoCodec)ReflectionUtils.newInstance((Class)conf.getClassByName(encCodecClass), (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal crypto codec!");
        }
        LOG.info((Object)("Created a Codec object of type: " + encCodecClass));
        DataOutputBuffer data = new DataOutputBuffer();
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            key.write((DataOutput)data);
            value.write((DataOutput)data);
        }
        LOG.info((Object)("Generated " + count + " records"));
        DataOutputBuffer encryptedDataBuffer = new DataOutputBuffer();
        CryptoOutputStream out = new CryptoOutputStream((OutputStream)encryptedDataBuffer, encCodec, 4096, key, iv);
        out.write(data.getData(), 0, data.getLength());
        out.flush();
        out.close();
        LOG.info((Object)"Finished encrypting data");
        CryptoCodec decCodec = null;
        try {
            decCodec = (CryptoCodec)ReflectionUtils.newInstance((Class)conf.getClassByName(decCodecClass), (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal crypto codec!");
        }
        LOG.info((Object)("Created a Codec object of type: " + decCodecClass));
        DataInputBuffer decryptedDataBuffer = new DataInputBuffer();
        decryptedDataBuffer.reset(encryptedDataBuffer.getData(), 0, encryptedDataBuffer.getLength());
        CryptoInputStream in = new CryptoInputStream((InputStream)decryptedDataBuffer, decCodec, 4096, key, iv);
        DataInputStream dataIn = new DataInputStream(new BufferedInputStream((InputStream)in));
        DataInputBuffer originalData = new DataInputBuffer();
        originalData.reset(data.getData(), 0, data.getLength());
        DataInputStream originalIn = new DataInputStream(new BufferedInputStream((InputStream)originalData));
        for (int i = 0; i < count; ++i) {
            RandomDatum k1 = new RandomDatum();
            RandomDatum v1 = new RandomDatum();
            k1.readFields(originalIn);
            v1.readFields(originalIn);
            RandomDatum k2 = new RandomDatum();
            RandomDatum v2 = new RandomDatum();
            k2.readFields(dataIn);
            v2.readFields(dataIn);
            Assert.assertTrue((String)"original and encrypted-then-decrypted-output not equal", (k1.equals(k2) && v1.equals(v2) ? 1 : 0) != 0);
            HashMap<RandomDatum, String> m = new HashMap<RandomDatum, String>();
            m.put(k1, k1.toString());
            m.put(v1, v1.toString());
            String result = (String)m.get(k2);
            Assert.assertEquals((String)"k1 and k2 hashcode not equal", (Object)result, (Object)k1.toString());
            result = (String)m.get(v2);
            Assert.assertEquals((String)"v1 and v2 hashcode not equal", (Object)result, (Object)v1.toString());
        }
        originalData.reset(data.getData(), 0, data.getLength());
        decryptedDataBuffer.reset(encryptedDataBuffer.getData(), 0, encryptedDataBuffer.getLength());
        in = new CryptoInputStream((InputStream)decryptedDataBuffer, decCodec, 4096, key, iv);
        originalIn = new DataInputStream(new BufferedInputStream((InputStream)originalData));
        do {
            expected = originalIn.read();
            Assert.assertEquals((String)"Decrypted stream read by byte does not match", (long)expected, (long)in.read());
        } while (expected != -1);
        originalData.reset(data.getData(), 0, data.getLength());
        decryptedDataBuffer.reset(encryptedDataBuffer.getData(), 0, encryptedDataBuffer.getLength());
        in = new CryptoInputStream((InputStream)new TestCryptoStreams.FakeInputStream(decryptedDataBuffer), decCodec, 4096, key, iv);
        int seekPos = data.getLength() / 3;
        in.seek((long)seekPos);
        TestCryptoStreams.FakeInputStream originalInput = new TestCryptoStreams.FakeInputStream(originalData);
        originalInput.seek(seekPos);
        do {
            expected = originalInput.read();
            Assert.assertEquals((String)"Decrypted stream read by byte does not match", (long)expected, (long)in.read());
        } while (expected != -1);
        LOG.info((Object)("SUCCESS! Completed checking " + count + " records"));
        this.testSecureRandom(encCodec);
    }

    private void testSecureRandom(CryptoCodec codec) {
        this.checkSecureRandom(codec, 16);
        this.checkSecureRandom(codec, 32);
        this.checkSecureRandom(codec, 128);
    }

    private void checkSecureRandom(CryptoCodec codec, int len) {
        byte[] rand = new byte[len];
        byte[] rand1 = new byte[len];
        codec.generateSecureRandom(rand);
        codec.generateSecureRandom(rand1);
        Assert.assertEquals((long)len, (long)rand.length);
        Assert.assertEquals((long)len, (long)rand1.length);
        Assert.assertFalse((boolean)Arrays.equals(rand, rand1));
    }

    @Test(timeout=120000L)
    public void testCalculateIV() throws Exception {
        long j;
        long i;
        JceAesCtrCryptoCodec codec = new JceAesCtrCryptoCodec();
        codec.setConf(this.conf);
        SecureRandom sr = new SecureRandom();
        byte[] initIV = new byte[16];
        byte[] IV = new byte[16];
        long iterations = 1000L;
        long counter = 10000L;
        for (int i2 = 0; i2 < 8; ++i2) {
            initIV[8 + i2] = -1;
        }
        for (long j2 = 0L; j2 < counter; ++j2) {
            this.assertIVCalculation((CryptoCodec)codec, initIV, j2, IV);
        }
        for (i = 0L; i < iterations; ++i) {
            sr.nextBytes(initIV);
            for (j = 0L; j < counter; ++j) {
                this.assertIVCalculation((CryptoCodec)codec, initIV, j, IV);
            }
        }
        for (i = 0L; i < iterations; ++i) {
            sr.nextBytes(initIV);
            for (j = 0L; j < counter; ++j) {
                long c = sr.nextLong();
                this.assertIVCalculation((CryptoCodec)codec, initIV, c, IV);
            }
        }
    }

    private void assertIVCalculation(CryptoCodec codec, byte[] initIV, long counter, byte[] IV) {
        codec.calculateIV(initIV, counter, IV);
        BigInteger iv = new BigInteger(1, IV);
        BigInteger ref = TestCryptoCodec.calculateRef(initIV, counter);
        Assert.assertTrue((String)"Calculated IV don't match with the reference", (boolean)iv.equals(ref));
    }

    private static BigInteger calculateRef(byte[] initIV, long counter) {
        byte[] cb = Longs.toByteArray((long)counter);
        BigInteger bi = new BigInteger(1, initIV);
        return bi.add(new BigInteger(1, cb));
    }
}

