/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util;

import java.io.UnsupportedEncodingException;
import org.apache.avro.io.BinaryData;
import org.apache.avro.reflect.Stringable;

@Stringable
public class Utf8
implements Comparable<Utf8> {
    private static final byte[] EMPTY = new byte[0];
    byte[] bytes = EMPTY;
    int length;

    public Utf8() {
    }

    public Utf8(String string) {
        try {
            this.bytes = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.length = this.bytes.length;
    }

    public Utf8(byte[] bytes) {
        this.bytes = bytes;
        this.length = bytes.length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.length;
    }

    public Utf8 setLength(int newLength) {
        if (this.length < newLength) {
            byte[] newBytes = new byte[newLength];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.length);
            this.bytes = newBytes;
        }
        this.length = newLength;
        return this;
    }

    public String toString() {
        try {
            return new String(this.bytes, 0, this.length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Utf8)) {
            return false;
        }
        Utf8 that = (Utf8)o;
        if (this.length != that.length) {
            return false;
        }
        byte[] thatBytes = that.bytes;
        for (int i = 0; i < this.length; ++i) {
            if (this.bytes[i] == thatBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.length;
        for (int i = 0; i < this.length; ++i) {
            hash += this.bytes[i] & 0xFF;
        }
        return hash;
    }

    @Override
    public int compareTo(Utf8 that) {
        return BinaryData.compareBytes(this.bytes, 0, this.length, that.bytes, 0, that.length);
    }
}

