/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.recipes.test;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.minicluster.MiniAccumuloCluster;
import org.apache.accumulo.minicluster.MiniAccumuloConfig;
import org.apache.commons.io.FileUtils;
import org.apache.fluo.api.client.FluoAdmin;
import org.apache.fluo.api.client.FluoFactory;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.api.mini.MiniFluo;
import org.apache.fluo.recipes.accumulo.ops.TableOperations;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public class AccumuloExportITBase {
    public static final String ACCUMULO_USER = "root";
    public static final String ACCUMULO_PASSWORD = "secret";
    private static File baseDir;
    private static MiniAccumuloCluster cluster;
    private FluoConfiguration fluoConfig;
    private MiniFluo miniFluo;
    protected static AtomicInteger tableCounter;
    private boolean startMiniFluo;

    protected AccumuloExportITBase() {
        this(true);
    }

    protected AccumuloExportITBase(boolean startMiniFluo) {
        this.startMiniFluo = startMiniFluo;
    }

    @BeforeClass
    public static void setupMiniAccumulo() throws Exception {
        try {
            File targetDir = new File("target");
            baseDir = targetDir.exists() && targetDir.isDirectory() ? new File(targetDir, "accumuloExportIT-" + UUID.randomUUID()) : new File(FileUtils.getTempDirectory(), "accumuloExportIT-" + UUID.randomUUID());
            FileUtils.deleteDirectory((File)baseDir);
            MiniAccumuloConfig cfg = new MiniAccumuloConfig(baseDir, ACCUMULO_PASSWORD);
            cluster = new MiniAccumuloCluster(cfg);
            cluster.start();
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    @AfterClass
    public static void tearDownMiniAccumulo() throws Exception {
        cluster.stop();
        FileUtils.deleteDirectory((File)baseDir);
    }

    @Before
    public void setupMiniFluo() throws Exception {
        this.resetFluoConfig();
        this.preFluoInitHook();
        FluoFactory.newAdmin((SimpleConfiguration)this.fluoConfig).initialize(new FluoAdmin.InitializationOptions().setClearTable(true).setClearZookeeper(true));
        this.postFluoInitHook();
        this.miniFluo = this.startMiniFluo ? FluoFactory.newMiniFluo((SimpleConfiguration)this.fluoConfig) : null;
    }

    @After
    public void tearDownMiniFluo() throws Exception {
        if (this.miniFluo != null) {
            this.miniFluo.close();
            this.miniFluo = null;
        }
    }

    protected void preFluoInitHook() throws Exception {
    }

    protected void postFluoInitHook() throws Exception {
        TableOperations.optimizeTable((FluoConfiguration)this.fluoConfig);
    }

    protected MiniAccumuloCluster getMiniAccumuloCluster() {
        return cluster;
    }

    protected synchronized MiniFluo getMiniFluo() {
        return this.miniFluo;
    }

    protected Connector getAccumuloConnector() {
        try {
            return cluster.getConnector(ACCUMULO_USER, ACCUMULO_PASSWORD);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    protected synchronized FluoConfiguration getFluoConfiguration() {
        return this.fluoConfig;
    }

    public static void configureFromMAC(FluoConfiguration fluoConfig, MiniAccumuloCluster cluster) {
        fluoConfig.setMiniStartAccumulo(false);
        fluoConfig.setAccumuloInstance(cluster.getInstanceName());
        fluoConfig.setAccumuloUser(ACCUMULO_USER);
        fluoConfig.setAccumuloPassword(cluster.getConfig().getRootPassword());
        fluoConfig.setInstanceZookeepers(cluster.getZooKeepers() + "/fluo");
        fluoConfig.setAccumuloZookeepers(cluster.getZooKeepers());
    }

    private void resetFluoConfig() {
        this.fluoConfig = new FluoConfiguration();
        AccumuloExportITBase.configureFromMAC(this.fluoConfig, cluster);
        this.fluoConfig.setApplicationName("fluo-it");
        this.fluoConfig.setAccumuloTable("fluo" + tableCounter.getAndIncrement());
    }

    static {
        tableCounter = new AtomicInteger(1);
    }
}

