/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.recipes.core.types;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import org.apache.fluo.api.client.SnapshotBase;
import org.apache.fluo.api.client.TransactionBase;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.exceptions.AlreadySetException;
import org.apache.fluo.recipes.core.types.Encoder;
import org.apache.fluo.recipes.core.types.TypeLayer;
import org.apache.fluo.recipes.core.types.TypedSnapshotBase;

public class TypedTransactionBase
extends TypedSnapshotBase
implements TransactionBase {
    private final TransactionBase tx;
    private final Encoder encoder;
    private final TypeLayer tl;

    @VisibleForTesting
    protected TypedTransactionBase(TransactionBase tx, Encoder encoder, TypeLayer tl) {
        super((SnapshotBase)tx, encoder, tl);
        this.tx = tx;
        this.encoder = encoder;
        this.tl = tl;
    }

    public MutatorRowMethods mutate() {
        return new MutatorRowMethods();
    }

    public void set(Bytes row, Column col, Bytes value) throws AlreadySetException {
        this.tx.set(row, col, value);
    }

    public void set(CharSequence row, Column col, CharSequence value) throws AlreadySetException {
        this.tx.set(row, col, value);
    }

    public void setWeakNotification(Bytes row, Column col) {
        this.tx.setWeakNotification(row, col);
    }

    public void setWeakNotification(CharSequence row, Column col) {
        this.tx.setWeakNotification(row, col);
    }

    public void delete(Bytes row, Column col) throws AlreadySetException {
        this.tx.delete(row, col);
    }

    public void delete(CharSequence row, Column col) {
        this.tx.delete(row, col);
    }

    public class MutatorRowMethods
    extends TypeLayer.RowMethods<MutatorFamilyMethods> {
        MutatorRowMethods() {
        }

        @Override
        MutatorFamilyMethods create(TypeLayer.Data data) {
            return new MutatorFamilyMethods(data);
        }
    }

    public class MutatorFamilyMethods
    extends TypeLayer.FamilyMethods<MutatorQualifierMethods, Mutator> {
        MutatorFamilyMethods(TypeLayer.Data data) {
            TypeLayer typeLayer = TypedTransactionBase.this.tl;
            typeLayer.getClass();
            super(data);
        }

        @Override
        MutatorQualifierMethods create1(TypeLayer.Data data) {
            return new MutatorQualifierMethods(data);
        }

        @Override
        Mutator create2(TypeLayer.Data data) {
            return new Mutator(data);
        }
    }

    public class MutatorQualifierMethods
    extends TypeLayer.QualifierMethods<VisibilityMutator> {
        MutatorQualifierMethods(TypeLayer.Data data) {
            TypeLayer typeLayer = TypedTransactionBase.this.tl;
            typeLayer.getClass();
            super(data);
        }

        @Override
        VisibilityMutator create(TypeLayer.Data data) {
            return new VisibilityMutator(data);
        }
    }

    public class VisibilityMutator
    extends Mutator {
        VisibilityMutator(TypeLayer.Data data) {
            super(data);
        }

        public Mutator vis(String cv) {
            this.checkNotSet();
            this.data.vis = Bytes.of((String)cv);
            return new Mutator(this.data);
        }

        public Mutator vis(Bytes cv) {
            this.checkNotSet();
            this.data.vis = cv;
            return new Mutator(this.data);
        }

        public Mutator vis(byte[] cv) {
            this.checkNotSet();
            this.data.vis = Bytes.of((byte[])cv);
            return new Mutator(this.data);
        }

        public Mutator vis(ByteBuffer cv) {
            this.checkNotSet();
            this.data.vis = Bytes.of((ByteBuffer)cv);
            return new Mutator(this.data);
        }
    }

    public class Mutator {
        private boolean set = false;
        TypeLayer.Data data;

        Mutator(TypeLayer.Data data) {
            this.data = data;
        }

        void checkNotSet() {
            if (this.set) {
                throw new IllegalStateException("Already set value");
            }
        }

        public void set(Bytes bytes) throws AlreadySetException {
            this.checkNotSet();
            TypedTransactionBase.this.tx.set(this.data.row, this.data.getCol(), bytes);
            this.set = true;
        }

        public void set(String s) throws AlreadySetException {
            this.set(TypedTransactionBase.this.encoder.encode(s));
        }

        public void set(int i) throws AlreadySetException {
            this.set(TypedTransactionBase.this.encoder.encode(i));
        }

        public void set(long l) throws AlreadySetException {
            this.set(TypedTransactionBase.this.encoder.encode(l));
        }

        public void set(float f) throws AlreadySetException {
            this.set(TypedTransactionBase.this.encoder.encode(f));
        }

        public void set(double d) throws AlreadySetException {
            this.set(TypedTransactionBase.this.encoder.encode(d));
        }

        public void set(boolean b) throws AlreadySetException {
            this.set(TypedTransactionBase.this.encoder.encode(b));
        }

        public void set(byte[] ba) throws AlreadySetException {
            this.set(Bytes.of((byte[])ba));
        }

        public void set(ByteBuffer bb) throws AlreadySetException {
            this.set(Bytes.of((ByteBuffer)bb));
        }

        public void set() throws AlreadySetException {
            this.set(Bytes.EMPTY);
        }

        public int increment(int i) throws AlreadySetException {
            this.checkNotSet();
            Bytes val = TypedTransactionBase.this.tx.get(this.data.row, this.data.getCol());
            int v = 0;
            if (val != null) {
                v = TypedTransactionBase.this.encoder.decodeInteger(val);
            }
            TypedTransactionBase.this.tx.set(this.data.row, this.data.getCol(), TypedTransactionBase.this.encoder.encode(v + i));
            return v;
        }

        public long increment(long l) throws AlreadySetException {
            this.checkNotSet();
            Bytes val = TypedTransactionBase.this.tx.get(this.data.row, this.data.getCol());
            long v = 0L;
            if (val != null) {
                v = TypedTransactionBase.this.encoder.decodeLong(val);
            }
            TypedTransactionBase.this.tx.set(this.data.row, this.data.getCol(), TypedTransactionBase.this.encoder.encode(v + l));
            return v;
        }

        public void delete() throws AlreadySetException {
            this.checkNotSet();
            TypedTransactionBase.this.tx.delete(this.data.row, this.data.getCol());
            this.set = true;
        }

        public void weaklyNotify() {
            this.checkNotSet();
            TypedTransactionBase.this.tx.setWeakNotification(this.data.row, this.data.getCol());
            this.set = true;
        }
    }
}

