/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.recipes.core.types;

import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.DefaultedMap;
import org.apache.fluo.api.client.AbstractSnapshotBase;
import org.apache.fluo.api.client.SnapshotBase;
import org.apache.fluo.api.client.scanner.ScannerBuilder;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.RowColumn;
import org.apache.fluo.recipes.core.types.Encoder;
import org.apache.fluo.recipes.core.types.TypeLayer;

public class TypedSnapshotBase
extends AbstractSnapshotBase
implements SnapshotBase {
    private SnapshotBase snapshot;
    private Encoder encoder;
    private TypeLayer tl;

    TypedSnapshotBase(SnapshotBase snapshot, Encoder encoder, TypeLayer tl) {
        this.snapshot = snapshot;
        this.encoder = encoder;
        this.tl = tl;
    }

    public Bytes get(Bytes row, Column column) {
        return this.snapshot.get(row, column);
    }

    public Map<Column, Bytes> get(Bytes row, Set<Column> columns) {
        return this.snapshot.get(row, columns);
    }

    public Map<RowColumn, Bytes> get(Collection<RowColumn> rowColumns) {
        return this.snapshot.get(rowColumns);
    }

    public Map<Bytes, Map<Column, Bytes>> get(Collection<Bytes> rows, Set<Column> columns) {
        return this.snapshot.get(rows, columns);
    }

    public ValueRowMethods get() {
        return new ValueRowMethods();
    }

    public ScannerBuilder scanner() {
        return this.snapshot.scanner();
    }

    private Map<Column, Value> wrap(Map<Column, Bytes> map) {
        Map ret = Maps.transformValues(map, input -> new Value((Bytes)input));
        return Collections.unmodifiableMap(DefaultedMap.decorate((Map)ret, (Object)new Value((Bytes)null)));
    }

    public long getStartTimestamp() {
        return this.snapshot.getStartTimestamp();
    }

    public String gets(CharSequence row, Column column) {
        return this.snapshot.gets(row, column);
    }

    public Map<Column, String> gets(CharSequence row, Set<Column> columns) {
        return this.snapshot.gets(row, columns);
    }

    public Map<String, Map<Column, String>> gets(Collection<? extends CharSequence> rows, Set<Column> columns) {
        return this.snapshot.gets(rows, columns);
    }

    public Map<RowColumn, String> gets(Collection<RowColumn> rowColumns) {
        return this.snapshot.gets(rowColumns);
    }

    public class ValueRowMethods
    extends TypeLayer.RowMethods<ValueFamilyMethods> {
        ValueRowMethods() {
        }

        @Override
        ValueFamilyMethods create(TypeLayer.Data data) {
            return new ValueFamilyMethods(data);
        }

        public ColumnsMethods rows(Collection<Bytes> rows) {
            return new ColumnsMethods(rows);
        }

        public ColumnsMethods rows(Bytes ... rows) {
            return new ColumnsMethods(Arrays.asList(rows));
        }

        public ColumnsMethods rowsString(String ... rows) {
            return this.rowsString(Arrays.asList(rows));
        }

        public ColumnsMethods rowsString(Collection<String> rows) {
            ArrayList<Bytes> conv = new ArrayList<Bytes>();
            for (String row : rows) {
                conv.add(TypedSnapshotBase.this.encoder.encode(row));
            }
            return this.rows(conv);
        }

        public ColumnsMethods rowsLong(Long ... rows) {
            return this.rowsLong(Arrays.asList(rows));
        }

        public ColumnsMethods rowsLong(Collection<Long> rows) {
            ArrayList<Bytes> conv = new ArrayList<Bytes>();
            for (Long row : rows) {
                conv.add(TypedSnapshotBase.this.encoder.encode(row));
            }
            return this.rows(conv);
        }

        public ColumnsMethods rowsInteger(Integer ... rows) {
            return this.rowsInteger(Arrays.asList(rows));
        }

        public ColumnsMethods rowsInteger(Collection<Integer> rows) {
            ArrayList<Bytes> conv = new ArrayList<Bytes>();
            for (Integer row : rows) {
                conv.add(TypedSnapshotBase.this.encoder.encode(row));
            }
            return this.rows(conv);
        }

        public ColumnsMethods rowsBytes(byte[] ... rows) {
            return this.rowsBytes(Arrays.asList(rows));
        }

        public ColumnsMethods rowsBytes(Collection<byte[]> rows) {
            ArrayList<Bytes> conv = new ArrayList<Bytes>();
            for (byte[] row : rows) {
                conv.add(Bytes.of((byte[])row));
            }
            return this.rows(conv);
        }

        public ColumnsMethods rowsByteBuffers(ByteBuffer ... rows) {
            return this.rowsByteBuffers(Arrays.asList(rows));
        }

        public ColumnsMethods rowsByteBuffers(Collection<ByteBuffer> rows) {
            ArrayList<Bytes> conv = new ArrayList<Bytes>();
            for (ByteBuffer row : rows) {
                conv.add(Bytes.of((ByteBuffer)row));
            }
            return this.rows(conv);
        }
    }

    public class ColumnsMethods {
        private Collection<Bytes> rows;

        public ColumnsMethods(Collection<Bytes> rows) {
            this.rows = rows;
        }

        public MapConverter columns(Set<Column> columns) {
            return new MapConverter(this.rows, columns);
        }

        public MapConverter columns(Column ... columns) {
            return this.columns(new HashSet<Column>(Arrays.asList(columns)));
        }
    }

    public class MapConverter {
        private Collection<Bytes> rows;
        private Set<Column> columns;

        public MapConverter(Collection<Bytes> rows, Set<Column> columns) {
            this.rows = rows;
            this.columns = columns;
        }

        private Map<Bytes, Map<Column, Bytes>> getInput() {
            try {
                return TypedSnapshotBase.this.snapshot.get(this.rows, this.columns);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Map wrap2(Map m) {
            return Collections.unmodifiableMap(DefaultedMap.decorate((Map)m, (Object)new DefaultedMap((Object)new Value((Bytes)null))));
        }

        public Map<String, Map<Column, Value>> toStringMap() {
            Map<Bytes, Map<Column, Bytes>> in = this.getInput();
            HashMap<String, Map> out = new HashMap<String, Map>();
            for (Map.Entry<Bytes, Map<Column, Bytes>> rowEntry : in.entrySet()) {
                out.put(TypedSnapshotBase.this.encoder.decodeString(rowEntry.getKey()), TypedSnapshotBase.this.wrap(rowEntry.getValue()));
            }
            return this.wrap2(out);
        }

        public Map<Long, Map<Column, Value>> toLongMap() {
            Map<Bytes, Map<Column, Bytes>> in = this.getInput();
            HashMap<Long, Map> out = new HashMap<Long, Map>();
            for (Map.Entry<Bytes, Map<Column, Bytes>> rowEntry : in.entrySet()) {
                out.put(TypedSnapshotBase.this.encoder.decodeLong(rowEntry.getKey()), TypedSnapshotBase.this.wrap(rowEntry.getValue()));
            }
            return this.wrap2(out);
        }

        public Map<Integer, Map<Column, Value>> toIntegerMap() {
            Map<Bytes, Map<Column, Bytes>> in = this.getInput();
            HashMap<Integer, Map> out = new HashMap<Integer, Map>();
            for (Map.Entry<Bytes, Map<Column, Bytes>> rowEntry : in.entrySet()) {
                out.put(TypedSnapshotBase.this.encoder.decodeInteger(rowEntry.getKey()), TypedSnapshotBase.this.wrap(rowEntry.getValue()));
            }
            return this.wrap2(out);
        }

        public Map<Bytes, Map<Column, Value>> toBytesMap() {
            Map<Bytes, Map<Column, Bytes>> in = this.getInput();
            HashMap<Bytes, Map> out = new HashMap<Bytes, Map>();
            for (Map.Entry<Bytes, Map<Column, Bytes>> rowEntry : in.entrySet()) {
                out.put(rowEntry.getKey(), TypedSnapshotBase.this.wrap(rowEntry.getValue()));
            }
            return this.wrap2(out);
        }
    }

    public class ValueFamilyMethods
    extends TypeLayer.FamilyMethods<ValueQualifierBuilder, Value> {
        ValueFamilyMethods(TypeLayer.Data data) {
            TypeLayer typeLayer = TypedSnapshotBase.this.tl;
            typeLayer.getClass();
            super(data);
        }

        @Override
        ValueQualifierBuilder create1(TypeLayer.Data data) {
            return new ValueQualifierBuilder(data);
        }

        @Override
        Value create2(TypeLayer.Data data) {
            return new Value(data);
        }

        public Map<Column, Value> columns(Set<Column> columns) {
            try {
                return TypedSnapshotBase.this.wrap(TypedSnapshotBase.this.snapshot.get(this.data.row, columns));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Map<Column, Value> columns(Column ... columns) {
            try {
                return TypedSnapshotBase.this.wrap(TypedSnapshotBase.this.snapshot.get(this.data.row, new HashSet<Column>(Arrays.asList(columns))));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class ValueQualifierBuilder
    extends TypeLayer.QualifierMethods<VisibilityMethods> {
        ValueQualifierBuilder(TypeLayer.Data data) {
            TypeLayer typeLayer = TypedSnapshotBase.this.tl;
            typeLayer.getClass();
            super(data);
        }

        @Override
        VisibilityMethods create(TypeLayer.Data data) {
            return new VisibilityMethods(data);
        }
    }

    public class Value {
        private Bytes bytes;
        private boolean gotBytes = false;
        TypeLayer.Data data;

        public Bytes getBytes() {
            if (!this.gotBytes) {
                try {
                    this.bytes = TypedSnapshotBase.this.snapshot.get(this.data.row, this.data.getCol());
                    this.gotBytes = true;
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
            return this.bytes;
        }

        private Value(Bytes bytes) {
            this.bytes = bytes;
            this.gotBytes = true;
        }

        private Value(TypeLayer.Data data) {
            this.data = data;
            this.gotBytes = false;
        }

        public Integer toInteger() {
            if (this.getBytes() == null) {
                return null;
            }
            return TypedSnapshotBase.this.encoder.decodeInteger(this.getBytes());
        }

        public int toInteger(int defaultValue) {
            if (this.getBytes() == null) {
                return defaultValue;
            }
            return TypedSnapshotBase.this.encoder.decodeInteger(this.getBytes());
        }

        public Long toLong() {
            if (this.getBytes() == null) {
                return null;
            }
            return TypedSnapshotBase.this.encoder.decodeLong(this.getBytes());
        }

        public long toLong(long defaultValue) {
            if (this.getBytes() == null) {
                return defaultValue;
            }
            return TypedSnapshotBase.this.encoder.decodeLong(this.getBytes());
        }

        public String toString() {
            if (this.getBytes() == null) {
                return null;
            }
            return TypedSnapshotBase.this.encoder.decodeString(this.getBytes());
        }

        public String toString(String defaultValue) {
            if (this.getBytes() == null) {
                return defaultValue;
            }
            return TypedSnapshotBase.this.encoder.decodeString(this.getBytes());
        }

        public Float toFloat() {
            if (this.getBytes() == null) {
                return null;
            }
            return Float.valueOf(TypedSnapshotBase.this.encoder.decodeFloat(this.getBytes()));
        }

        public float toFloat(float defaultValue) {
            if (this.getBytes() == null) {
                return defaultValue;
            }
            return TypedSnapshotBase.this.encoder.decodeFloat(this.getBytes());
        }

        public Double toDouble() {
            if (this.getBytes() == null) {
                return null;
            }
            return TypedSnapshotBase.this.encoder.decodeDouble(this.getBytes());
        }

        public double toDouble(double defaultValue) {
            if (this.getBytes() == null) {
                return defaultValue;
            }
            return TypedSnapshotBase.this.encoder.decodeDouble(this.getBytes());
        }

        public Boolean toBoolean() {
            if (this.getBytes() == null) {
                return null;
            }
            return TypedSnapshotBase.this.encoder.decodeBoolean(this.getBytes());
        }

        public boolean toBoolean(boolean defaultValue) {
            if (this.getBytes() == null) {
                return defaultValue;
            }
            return TypedSnapshotBase.this.encoder.decodeBoolean(this.getBytes());
        }

        public byte[] toBytes() {
            if (this.getBytes() == null) {
                return null;
            }
            return this.getBytes().toArray();
        }

        public byte[] toBytes(byte[] defaultValue) {
            if (this.getBytes() == null) {
                return defaultValue;
            }
            return this.getBytes().toArray();
        }

        public ByteBuffer toByteBuffer() {
            if (this.getBytes() == null) {
                return null;
            }
            return ByteBuffer.wrap(this.getBytes().toArray());
        }

        public ByteBuffer toByteBuffer(ByteBuffer defaultValue) {
            if (this.getBytes() == null) {
                return defaultValue;
            }
            return this.toByteBuffer();
        }

        public int hashCode() {
            if (this.getBytes() == null) {
                return 0;
            }
            return this.getBytes().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Value) {
                Value ov = (Value)o;
                if (this.getBytes() == null) {
                    return ov.getBytes() == null;
                }
                return this.getBytes().equals((Object)ov.getBytes());
            }
            return false;
        }
    }

    public class VisibilityMethods
    extends Value {
        VisibilityMethods(TypeLayer.Data data) {
            super(data);
        }

        public Value vis(Bytes cv) {
            this.data.vis = cv;
            return new Value(this.data);
        }

        public Value vis(byte[] cv) {
            this.data.vis = Bytes.of((byte[])cv);
            return new Value(this.data);
        }

        public Value vis(ByteBuffer bb) {
            this.data.vis = Bytes.of((ByteBuffer)bb);
            return new Value(this.data);
        }

        public Value vis(String cv) {
            this.data.vis = Bytes.of((String)cv);
            return new Value(this.data);
        }
    }
}

