/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.recipes.core.types;

import java.nio.ByteBuffer;
import org.apache.fluo.api.client.Snapshot;
import org.apache.fluo.api.client.Transaction;
import org.apache.fluo.api.client.TransactionBase;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.recipes.core.types.Encoder;
import org.apache.fluo.recipes.core.types.TypedSnapshot;
import org.apache.fluo.recipes.core.types.TypedTransaction;
import org.apache.fluo.recipes.core.types.TypedTransactionBase;

public class TypeLayer {
    private Encoder encoder;

    public TypeLayer(Encoder encoder) {
        this.encoder = encoder;
    }

    public CFB bc() {
        return new CFB();
    }

    public TypedSnapshot wrap(Snapshot snap) {
        return new TypedSnapshot(snap, this.encoder, this);
    }

    public TypedTransactionBase wrap(TransactionBase tx) {
        return new TypedTransactionBase(tx, this.encoder, this);
    }

    public TypedTransaction wrap(Transaction tx) {
        return new TypedTransaction(tx, this.encoder, this);
    }

    public class CFB
    extends SimpleFamilyMethods<CQB> {
        CFB() {
            super(new Data());
        }

        @Override
        CQB create1(Data data) {
            return new CQB(data);
        }
    }

    public class CQB
    extends QualifierMethods<VisibilityMethods> {
        CQB(Data data) {
            super(data);
        }

        @Override
        VisibilityMethods create(Data data) {
            return new VisibilityMethods(data);
        }
    }

    public static class VisibilityMethods {
        private Data data;

        VisibilityMethods(Data data) {
            this.data = data;
        }

        public Column vis() {
            return new Column(this.data.family, this.data.qual);
        }

        public Column vis(String cv) {
            return this.vis(Bytes.of((String)cv));
        }

        public Column vis(Bytes cv) {
            return new Column(this.data.family, this.data.qual, cv);
        }

        public Column vis(ByteBuffer cv) {
            return this.vis(Bytes.of((ByteBuffer)cv));
        }

        public Column vis(byte[] cv) {
            return this.vis(Bytes.of((byte[])cv));
        }
    }

    public abstract class QualifierMethods<R> {
        private Data data;

        QualifierMethods(Data data) {
            this.data = data;
        }

        abstract R create(Data var1);

        public R qual(String qualifier) {
            return this.qual(TypeLayer.this.encoder.encode(qualifier));
        }

        public R qual(int qualifier) {
            return this.qual(TypeLayer.this.encoder.encode(qualifier));
        }

        public R qual(long qualifier) {
            return this.qual(TypeLayer.this.encoder.encode(qualifier));
        }

        public R qual(byte[] qualifier) {
            return this.qual(Bytes.of((byte[])qualifier));
        }

        public R qual(ByteBuffer qualifier) {
            return this.qual(Bytes.of((ByteBuffer)qualifier));
        }

        public R qual(Bytes qualifier) {
            this.data.qual = qualifier;
            return this.create(this.data);
        }
    }

    public abstract class FamilyMethods<R1, R2>
    extends SimpleFamilyMethods<R1> {
        FamilyMethods(Data data) {
            super(data);
        }

        abstract R2 create2(Data var1);

        public R2 col(Column col) {
            this.data.family = col.getFamily();
            this.data.qual = col.getQualifier();
            this.data.vis = col.getVisibility();
            return this.create2(this.data);
        }
    }

    public abstract class SimpleFamilyMethods<R1> {
        Data data;

        SimpleFamilyMethods(Data data) {
            this.data = data;
        }

        abstract R1 create1(Data var1);

        public R1 fam(String family) {
            return this.fam(TypeLayer.this.encoder.encode(family));
        }

        public R1 fam(int family) {
            return this.fam(TypeLayer.this.encoder.encode(family));
        }

        public R1 fam(long family) {
            return this.fam(TypeLayer.this.encoder.encode(family));
        }

        public R1 fam(byte[] family) {
            return this.fam(Bytes.of((byte[])family));
        }

        public R1 fam(ByteBuffer family) {
            return this.fam(Bytes.of((ByteBuffer)family));
        }

        public R1 fam(Bytes family) {
            this.data.family = family;
            return this.create1(this.data);
        }
    }

    public abstract class RowMethods<R> {
        abstract R create(Data var1);

        public R row(String row) {
            return this.row(TypeLayer.this.encoder.encode(row));
        }

        public R row(int row) {
            return this.row(TypeLayer.this.encoder.encode(row));
        }

        public R row(long row) {
            return this.row(TypeLayer.this.encoder.encode(row));
        }

        public R row(byte[] row) {
            return this.row(Bytes.of((byte[])row));
        }

        public R row(ByteBuffer row) {
            return this.row(Bytes.of((ByteBuffer)row));
        }

        public R row(Bytes row) {
            Data data = new Data();
            data.row = row;
            R result = this.create(data);
            return result;
        }
    }

    static class Data {
        Bytes row;
        Bytes family;
        Bytes qual;
        Bytes vis;

        Data() {
        }

        Column getCol() {
            if (this.qual == null) {
                return new Column(this.family);
            }
            if (this.vis == null) {
                return new Column(this.family, this.qual);
            }
            return new Column(this.family, this.qual, this.vis);
        }
    }
}

