/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.recipes.core.transaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.RowColumn;
import org.apache.fluo.recipes.core.transaction.LogEntry;

public class TxLog {
    private List<LogEntry> logEntries = new ArrayList<LogEntry>();

    public void add(LogEntry entry) {
        this.logEntries.add(entry);
    }

    public void filteredAdd(LogEntry entry, Predicate<LogEntry> filter) {
        if (filter.test(entry)) {
            this.add(entry);
        }
    }

    public List<LogEntry> getLogEntries() {
        return Collections.unmodifiableList(this.logEntries);
    }

    public boolean isEmpty() {
        return this.logEntries.isEmpty();
    }

    public Map<RowColumn, Bytes> getOperationMap(LogEntry.Operation op) {
        HashMap<RowColumn, Bytes> opMap = new HashMap<RowColumn, Bytes>();
        for (LogEntry entry : this.logEntries) {
            if (!entry.getOp().equals((Object)op)) continue;
            opMap.put(new RowColumn(entry.getRow(), entry.getColumn()), entry.getValue());
        }
        return opMap;
    }
}

