/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.recipes.core.transaction;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.fluo.api.client.AbstractTransactionBase;
import org.apache.fluo.api.client.TransactionBase;
import org.apache.fluo.api.client.scanner.CellScanner;
import org.apache.fluo.api.client.scanner.ColumnScanner;
import org.apache.fluo.api.client.scanner.RowScanner;
import org.apache.fluo.api.client.scanner.RowScannerBuilder;
import org.apache.fluo.api.client.scanner.ScannerBuilder;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.ColumnValue;
import org.apache.fluo.api.data.RowColumn;
import org.apache.fluo.api.data.RowColumnValue;
import org.apache.fluo.api.data.Span;
import org.apache.fluo.api.exceptions.AlreadySetException;
import org.apache.fluo.recipes.core.transaction.LogEntry;
import org.apache.fluo.recipes.core.transaction.TxLog;

public class RecordingTransactionBase
extends AbstractTransactionBase
implements TransactionBase {
    private final TransactionBase txb;
    private final TxLog txLog = new TxLog();
    private final Predicate<LogEntry> filter;

    RecordingTransactionBase(TransactionBase txb, Predicate<LogEntry> filter) {
        this.txb = txb;
        this.filter = filter;
    }

    RecordingTransactionBase(TransactionBase txb) {
        this(txb, le -> true);
    }

    public void setWeakNotification(Bytes row, Column col) {
        this.txb.setWeakNotification(row, col);
    }

    public void set(Bytes row, Column col, Bytes value) throws AlreadySetException {
        this.txLog.filteredAdd(LogEntry.newSet(row, col, value), this.filter);
        this.txb.set(row, col, value);
    }

    public void delete(Bytes row, Column col) {
        this.txLog.filteredAdd(LogEntry.newDelete(row, col), this.filter);
        this.txb.delete(row, col);
    }

    public Bytes get(Bytes row, Column col) {
        Bytes val = this.txb.get(row, col);
        if (val != null) {
            this.txLog.filteredAdd(LogEntry.newGet(row, col, val), this.filter);
        }
        return val;
    }

    public Map<Column, Bytes> get(Bytes row, Set<Column> columns) {
        Map colVal = this.txb.get(row, columns);
        for (Map.Entry entry : colVal.entrySet()) {
            this.txLog.filteredAdd(LogEntry.newGet(row, (Column)entry.getKey(), (Bytes)entry.getValue()), this.filter);
        }
        return colVal;
    }

    public Map<Bytes, Map<Column, Bytes>> get(Collection<Bytes> rows, Set<Column> columns) {
        Map rowColVal = this.txb.get(rows, columns);
        for (Map.Entry rowEntry : rowColVal.entrySet()) {
            for (Map.Entry colEntry : ((Map)rowEntry.getValue()).entrySet()) {
                this.txLog.filteredAdd(LogEntry.newGet((Bytes)rowEntry.getKey(), (Column)colEntry.getKey(), (Bytes)colEntry.getValue()), this.filter);
            }
        }
        return rowColVal;
    }

    public Map<RowColumn, Bytes> get(Collection<RowColumn> rowColumns) {
        Map rowColVal = this.txb.get(rowColumns);
        for (Map.Entry rce : rowColVal.entrySet()) {
            this.txLog.filteredAdd(LogEntry.newGet(((RowColumn)rce.getKey()).getRow(), ((RowColumn)rce.getKey()).getColumn(), (Bytes)rce.getValue()), this.filter);
        }
        return rowColVal;
    }

    public ScannerBuilder scanner() {
        return new RtxScannerBuilder(this.txb.scanner());
    }

    public long getStartTimestamp() {
        return this.txb.getStartTimestamp();
    }

    public TxLog getTxLog() {
        return this.txLog;
    }

    public static RecordingTransactionBase wrap(TransactionBase txb) {
        return new RecordingTransactionBase(txb);
    }

    public static RecordingTransactionBase wrap(TransactionBase txb, Predicate<LogEntry> filter) {
        return new RecordingTransactionBase(txb, filter);
    }

    private class RtxScannerBuilder
    implements ScannerBuilder {
        private ScannerBuilder sb;

        public RtxScannerBuilder(ScannerBuilder sb) {
            this.sb = sb;
        }

        public ScannerBuilder over(Span span) {
            this.sb = this.sb.over(span);
            return this;
        }

        public ScannerBuilder fetch(Column ... columns) {
            this.sb = this.sb.fetch(columns);
            return this;
        }

        public ScannerBuilder fetch(Collection<Column> columns) {
            this.sb = this.sb.fetch(columns);
            return this;
        }

        public CellScanner build() {
            return new RtxCellSanner(this.sb.build());
        }

        public RowScannerBuilder byRow() {
            return new RtxRowScannerBuilder(this.sb.byRow());
        }
    }

    private class RtxRowScannerBuilder
    implements RowScannerBuilder {
        private RowScannerBuilder rsb;

        public RtxRowScannerBuilder(RowScannerBuilder rsb) {
            this.rsb = rsb;
        }

        public RowScanner build() {
            return new RtxRowScanner(this.rsb.build());
        }
    }

    private class RtxRowScanner
    implements RowScanner {
        private RowScanner scanner;

        public RtxRowScanner(RowScanner scanner) {
            this.scanner = scanner;
        }

        public Iterator<ColumnScanner> iterator() {
            return Iterators.transform((Iterator)this.scanner.iterator(), cs -> new RtxColumnScanner((ColumnScanner)cs));
        }
    }

    private class RtxColumnScanner
    implements ColumnScanner {
        private ColumnScanner cs;

        public RtxColumnScanner(ColumnScanner cs) {
            this.cs = cs;
        }

        public Iterator<ColumnValue> iterator() {
            return new RtxCVIterator(this.cs.getRow(), this.cs.iterator());
        }

        public Bytes getRow() {
            return this.cs.getRow();
        }

        public String getsRow() {
            return this.cs.getsRow();
        }
    }

    private class RtxCVIterator
    implements Iterator<ColumnValue> {
        private Iterator<ColumnValue> iter;
        private Bytes row;

        public RtxCVIterator(Bytes row, Iterator<ColumnValue> iterator) {
            this.row = row;
            this.iter = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public ColumnValue next() {
            ColumnValue cv = this.iter.next();
            RecordingTransactionBase.this.txLog.filteredAdd(LogEntry.newGet(this.row, cv.getColumn(), cv.getValue()), RecordingTransactionBase.this.filter);
            return cv;
        }
    }

    private class RtxCellSanner
    implements CellScanner {
        private CellScanner scanner;

        public RtxCellSanner(CellScanner scanner) {
            this.scanner = scanner;
        }

        public Iterator<RowColumnValue> iterator() {
            return new RtxIterator(this.scanner.iterator());
        }
    }

    private class RtxIterator
    implements Iterator<RowColumnValue> {
        private Iterator<RowColumnValue> iter;

        public RtxIterator(Iterator<RowColumnValue> iterator) {
            this.iter = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public RowColumnValue next() {
            RowColumnValue rcv = this.iter.next();
            RecordingTransactionBase.this.txLog.filteredAdd(LogEntry.newGet(rcv.getRow(), rcv.getColumn(), rcv.getValue()), RecordingTransactionBase.this.filter);
            return rcv;
        }
    }
}

