/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.recipes.core.transaction;

import java.util.Objects;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;

public class LogEntry {
    private Operation op;
    private Bytes row;
    private Column col;
    private Bytes value;

    private LogEntry() {
    }

    private LogEntry(Operation op, Bytes row, Column col, Bytes value) {
        Objects.requireNonNull(op);
        Objects.requireNonNull(row);
        Objects.requireNonNull(col);
        Objects.requireNonNull(value);
        this.op = op;
        this.row = row;
        this.col = col;
        this.value = value;
    }

    public Operation getOp() {
        return this.op;
    }

    public Bytes getRow() {
        return this.row;
    }

    public Column getColumn() {
        return this.col;
    }

    public Bytes getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof LogEntry) {
            LogEntry other = (LogEntry)o;
            return this.op == other.op && this.row.equals((Object)other.row) && this.col.equals((Object)other.col) && this.value.equals((Object)other.value);
        }
        return false;
    }

    public int hashCode() {
        int result = this.op.hashCode();
        result = 31 * result + this.row.hashCode();
        result = 31 * result + this.col.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "LogEntry{op=" + (Object)((Object)this.op) + ", row=" + this.row + ", col=" + this.col + ", value=" + this.value + "}";
    }

    public static LogEntry newGet(CharSequence row, Column col, CharSequence value) {
        return LogEntry.newGet(Bytes.of((CharSequence)row), col, Bytes.of((CharSequence)value));
    }

    public static LogEntry newGet(Bytes row, Column col, Bytes value) {
        return new LogEntry(Operation.GET, row, col, value);
    }

    public static LogEntry newSet(CharSequence row, Column col, CharSequence value) {
        return LogEntry.newSet(Bytes.of((CharSequence)row), col, Bytes.of((CharSequence)value));
    }

    public static LogEntry newSet(Bytes row, Column col, Bytes value) {
        return new LogEntry(Operation.SET, row, col, value);
    }

    public static LogEntry newDelete(CharSequence row, Column col) {
        return LogEntry.newDelete(Bytes.of((CharSequence)row), col);
    }

    public static LogEntry newDelete(Bytes row, Column col) {
        return new LogEntry(Operation.DELETE, row, col, Bytes.EMPTY);
    }

    public static enum Operation {
        GET,
        SET,
        DELETE;

    }
}

