/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.recipes.core.serialization;

import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.SimpleConfiguration;

public interface SimpleSerializer {
    public void init(SimpleConfiguration var1);

    public <T> byte[] serialize(T var1);

    public <T> T deserialize(byte[] var1, Class<T> var2);

    public static void setSerializer(FluoConfiguration fluoConfig, Class<? extends SimpleSerializer> serializerType) {
        SimpleSerializer.setSerializer(fluoConfig, serializerType.getName());
    }

    public static void setSerializer(FluoConfiguration fluoConfig, String serializerType) {
        fluoConfig.getAppConfiguration().setProperty("recipes.serializer", serializerType);
    }

    public static SimpleSerializer getInstance(SimpleConfiguration appConfig) {
        String serType = appConfig.getString("recipes.serializer", "org.apache.fluo.recipes.kryo.KryoSimplerSerializer");
        try {
            SimpleSerializer simplerSer = SimpleSerializer.class.getClassLoader().loadClass(serType).asSubclass(SimpleSerializer.class).newInstance();
            simplerSer.init(appConfig);
            return simplerSer;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

