/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.recipes.core.map;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.fluo.api.client.SnapshotBase;
import org.apache.fluo.api.client.TransactionBase;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.ObserverSpecification;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.RowColumn;
import org.apache.fluo.api.data.RowColumnValue;
import org.apache.fluo.api.data.Span;
import org.apache.fluo.recipes.core.common.RowRange;
import org.apache.fluo.recipes.core.common.TableOptimizations;
import org.apache.fluo.recipes.core.common.TransientRegistry;
import org.apache.fluo.recipes.core.map.CollisionFreeMapObserver;
import org.apache.fluo.recipes.core.map.Combiner;
import org.apache.fluo.recipes.core.map.NullUpdateObserver;
import org.apache.fluo.recipes.core.map.Update;
import org.apache.fluo.recipes.core.map.UpdateObserver;
import org.apache.fluo.recipes.core.serialization.SimpleSerializer;

public class CollisionFreeMap<K, V> {
    private static final String UPDATE_RANGE_END = ":u:~";
    private static final String DATA_RANGE_END = ":d:~";
    private String mapId;
    private Class<K> keyType;
    private Class<V> valType;
    private SimpleSerializer serializer;
    private Combiner<K, V> combiner;
    UpdateObserver<K, V> updateObserver;
    private long bufferSize;
    static final Column UPDATE_COL = new Column((CharSequence)"u", (CharSequence)"v");
    static final Column NEXT_COL = new Column((CharSequence)"u", (CharSequence)"next");
    private int numBuckets = -1;
    private static final Column DATA_COLUMN = new Column((CharSequence)"data", (CharSequence)"current");

    CollisionFreeMap(Options opts, SimpleSerializer serializer) throws Exception {
        this.mapId = opts.mapId;
        this.numBuckets = opts.numBuckets;
        this.keyType = this.getClass().getClassLoader().loadClass(opts.keyType);
        this.valType = this.getClass().getClassLoader().loadClass(opts.valueType);
        this.combiner = (Combiner)this.getClass().getClassLoader().loadClass(opts.combinerType).newInstance();
        this.serializer = serializer;
        this.updateObserver = opts.updateObserverType != null ? this.getClass().getClassLoader().loadClass(opts.updateObserverType).asSubclass(UpdateObserver.class).newInstance() : new NullUpdateObserver();
        this.bufferSize = opts.getBufferSize();
    }

    private V deserVal(Bytes val) {
        return this.serializer.deserialize(val.toArray(), this.valType);
    }

    private Bytes getKeyFromUpdateRow(Bytes prefix, Bytes row) {
        return row.subSequence(prefix.length(), row.length() - 8);
    }

    void process(TransactionBase tx, Bytes ntfyRow, Column col) throws Exception {
        Span span;
        Bytes nextKey = tx.get(ntfyRow, NEXT_COL);
        if (nextKey != null) {
            Span nextSpan;
            Bytes startRow = Bytes.builder((int)(ntfyRow.length() + nextKey.length())).append(ntfyRow).append(nextKey).toBytes();
            Span tmpSpan = Span.prefix((Bytes)ntfyRow);
            span = nextSpan = new Span(new RowColumn(startRow, UPDATE_COL), false, tmpSpan.getEnd(), tmpSpan.isEndInclusive());
        } else {
            span = Span.prefix((Bytes)ntfyRow);
        }
        Iterator iter = tx.scanner().over(span).fetch(new Column[]{UPDATE_COL}).build().iterator();
        HashMap updates = new HashMap();
        Bytes partiallyReadKey = null;
        boolean setNextKey = false;
        if (iter.hasNext()) {
            Bytes curRow;
            RowColumnValue rcv;
            Bytes val;
            Bytes lastKey = null;
            for (long approxMemUsed = 0L; iter.hasNext() && approxMemUsed < this.bufferSize; approxMemUsed += (long)val.length()) {
                Bytes serializedKey;
                rcv = (RowColumnValue)iter.next();
                curRow = rcv.getRow();
                tx.delete(curRow, UPDATE_COL);
                lastKey = serializedKey = this.getKeyFromUpdateRow(ntfyRow, curRow);
                ArrayList<Bytes> updateList = (ArrayList<Bytes>)updates.get(serializedKey);
                if (updateList == null) {
                    updateList = new ArrayList<Bytes>();
                    updates.put(serializedKey, updateList);
                }
                val = rcv.getValue();
                updateList.add(val);
                approxMemUsed += (long)curRow.length();
            }
            if (iter.hasNext()) {
                rcv = (RowColumnValue)iter.next();
                curRow = rcv.getRow();
                if (this.getKeyFromUpdateRow(ntfyRow, curRow).equals(lastKey)) {
                    partiallyReadKey = lastKey;
                    tx.set(ntfyRow, NEXT_COL, partiallyReadKey);
                } else {
                    Bytes nextPossible = Bytes.builder((int)(lastKey.length() + 1)).append(lastKey).append(new byte[]{0}).toBytes();
                    tx.set(ntfyRow, NEXT_COL, nextPossible);
                }
                setNextKey = true;
            } else if (nextKey != null) {
                tx.delete(ntfyRow, NEXT_COL);
            }
        } else if (nextKey != null) {
            tx.delete(ntfyRow, NEXT_COL);
        }
        if (nextKey != null || setNextKey) {
            tx.setWeakNotification(ntfyRow, col);
        }
        byte[] dataPrefix = ntfyRow.toArray();
        dataPrefix[Bytes.of((String)this.mapId).length() + 1] = 100;
        Bytes.BytesBuilder rowBuilder = Bytes.builder();
        rowBuilder.append(dataPrefix);
        int rowPrefixLen = rowBuilder.getLength();
        Set keysToFetch = updates.keySet();
        if (partiallyReadKey != null) {
            Bytes prk = partiallyReadKey;
            keysToFetch = Sets.filter(keysToFetch, b -> !b.equals((Object)prk));
        }
        Map<Bytes, Map<Column, Bytes>> currentVals = this.getCurrentValues(tx, rowBuilder, keysToFetch);
        ArrayList<Update<K, Object>> updatesToReport = new ArrayList<Update<K, Object>>(updates.size());
        for (Map.Entry entry : updates.entrySet()) {
            Optional<V> nv;
            rowBuilder.setLength(rowPrefixLen);
            Bytes currentValueRow = rowBuilder.append((Bytes)entry.getKey()).toBytes();
            Bytes currVal = (Bytes)currentVals.getOrDefault(currentValueRow, Collections.emptyMap()).get(DATA_COLUMN);
            Iterator ui = Iterators.transform(((List)entry.getValue()).iterator(), this::deserVal);
            K kd = this.serializer.deserialize(((Bytes)entry.getKey()).toArray(), this.keyType);
            if (partiallyReadKey != null && partiallyReadKey.equals(entry.getKey())) {
                nv = this.combiner.combine(kd, ui);
                if (!nv.isPresent()) continue;
                this.update(tx, Collections.singletonMap(kd, nv.get()));
                continue;
            }
            nv = this.combiner.combine(kd, this.concat(ui, currVal));
            Bytes newVal = nv.isPresent() ? Bytes.of((byte[])this.serializer.serialize(nv.get())) : null;
            if (!(newVal != null ^ currVal != null) && (currVal == null || currVal.equals((Object)newVal))) continue;
            if (newVal == null) {
                tx.delete(currentValueRow, DATA_COLUMN);
            } else {
                tx.set(currentValueRow, DATA_COLUMN, newVal);
            }
            Optional<Object> cvd = Optional.ofNullable(currVal).map(this::deserVal);
            updatesToReport.add(new Update<K, Object>(kd, cvd, nv));
        }
        updates.clear();
        currentVals.clear();
        if (updatesToReport.size() > 0) {
            this.updateObserver.updatingValues(tx, updatesToReport.iterator());
        }
    }

    private Map<Bytes, Map<Column, Bytes>> getCurrentValues(TransactionBase tx, Bytes.BytesBuilder prefix, Set<Bytes> keySet) {
        HashSet<Bytes> rows = new HashSet<Bytes>();
        int prefixLen = prefix.getLength();
        for (Bytes key : keySet) {
            prefix.setLength(prefixLen);
            rows.add(prefix.append(key).toBytes());
        }
        try {
            return tx.get(rows, Collections.singleton(DATA_COLUMN));
        }
        catch (IllegalArgumentException e) {
            System.out.println(rows.size());
            throw e;
        }
    }

    private Iterator<V> concat(Iterator<V> updates, Bytes currentVal) {
        if (currentVal == null) {
            return updates;
        }
        return Iterators.concat(updates, (Iterator)Iterators.singletonIterator(this.deserVal(currentVal)));
    }

    public V get(SnapshotBase tx, K key) {
        byte[] k = this.serializer.serialize(key);
        int hash = Hashing.murmur3_32().hashBytes(k).asInt();
        String bucketId = CollisionFreeMap.genBucketId(Math.abs(hash % this.numBuckets), this.numBuckets);
        Bytes.BytesBuilder rowBuilder = Bytes.builder();
        rowBuilder.append(this.mapId).append(":u:").append(bucketId).append(":").append(k);
        Iterator iter = tx.scanner().over(Span.prefix((Bytes)rowBuilder.toBytes())).build().iterator();
        Iterator ui = iter.hasNext() ? Iterators.transform((Iterator)iter, rcv -> this.deserVal(rcv.getValue())) : Collections.emptyList().iterator();
        rowBuilder.setLength(this.mapId.length());
        rowBuilder.append(":d:").append(bucketId).append(":").append(k);
        Bytes dataRow = rowBuilder.toBytes();
        Bytes cv = tx.get(dataRow, DATA_COLUMN);
        if (!ui.hasNext()) {
            if (cv == null) {
                return null;
            }
            return this.deserVal(cv);
        }
        return this.combiner.combine(key, this.concat(ui, cv)).orElse(null);
    }

    String getId() {
        return this.mapId;
    }

    public void update(TransactionBase tx, Map<K, V> updates) {
        Preconditions.checkState((this.numBuckets > 0 ? 1 : 0) != 0, (Object)"Not initialized");
        HashSet<String> buckets = new HashSet<String>();
        Bytes.BytesBuilder rowBuilder = Bytes.builder();
        rowBuilder.append(this.mapId).append(":u:");
        int prefixLength = rowBuilder.getLength();
        byte[] startTs = CollisionFreeMap.encSeq(tx.getStartTimestamp());
        for (Map.Entry<K, V> entry : updates.entrySet()) {
            byte[] k = this.serializer.serialize(entry.getKey());
            int hash = Hashing.murmur3_32().hashBytes(k).asInt();
            String bucketId = CollisionFreeMap.genBucketId(Math.abs(hash % this.numBuckets), this.numBuckets);
            rowBuilder.setLength(prefixLength);
            Bytes row = rowBuilder.append(bucketId).append(":").append(k).append(startTs).toBytes();
            Bytes val = Bytes.of((byte[])this.serializer.serialize(entry.getValue()));
            tx.set(row, UPDATE_COL, val);
            buckets.add(bucketId);
        }
        for (String bucketId : buckets) {
            rowBuilder.setLength(prefixLength);
            rowBuilder.append(bucketId).append(":");
            Bytes row = rowBuilder.toBytes();
            tx.setWeakNotification(row, new Column((CharSequence)"fluoRecipes", (CharSequence)("cfm:" + this.mapId)));
        }
    }

    static String genBucketId(int bucket, int maxBucket) {
        Preconditions.checkArgument((bucket >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxBucket > 0 ? 1 : 0) != 0);
        int bits = 32 - Integer.numberOfLeadingZeros(maxBucket);
        int bucketLen = bits / 4 + (bits % 4 > 0 ? 1 : 0);
        return Strings.padStart((String)Integer.toHexString(bucket), (int)bucketLen, (char)'0');
    }

    public static <K2, V2> CollisionFreeMap<K2, V2> getInstance(String mapId, SimpleConfiguration appConf) {
        Options opts = new Options(mapId, appConf);
        try {
            return new CollisionFreeMap(opts, SimpleSerializer.getInstance(appConf));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <K2, V2> Initializer<K2, V2> getInitializer(String mapId, int numBuckets, SimpleSerializer serializer) {
        return new Initializer(mapId, numBuckets, serializer);
    }

    public static void configure(FluoConfiguration fluoConfig, Options opts) {
        opts.save(fluoConfig.getAppConfiguration());
        fluoConfig.addObserver(new ObserverSpecification(CollisionFreeMapObserver.class.getName(), (Map)ImmutableMap.of((Object)"mapId", (Object)opts.mapId)));
        Bytes dataRangeEnd = Bytes.of((String)(opts.mapId + DATA_RANGE_END));
        Bytes updateRangeEnd = Bytes.of((String)(opts.mapId + UPDATE_RANGE_END));
        new TransientRegistry(fluoConfig.getAppConfiguration()).addTransientRange("cfm." + opts.mapId, new RowRange(dataRangeEnd, updateRangeEnd));
        TableOptimizations.registerOptimization(fluoConfig.getAppConfiguration(), opts.mapId, Optimizer.class);
    }

    private static byte[] encSeq(long l) {
        byte[] ret = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)(l >>> 0)};
        return ret;
    }

    public static class Optimizer
    implements TableOptimizations.TableOptimizationsFactory {
        @Override
        public TableOptimizations getTableOptimizations(String mapId, SimpleConfiguration appConfig) {
            Options opts = new Options(mapId, appConfig);
            Bytes.BytesBuilder rowBuilder = Bytes.builder();
            rowBuilder.append(mapId);
            ArrayList<Bytes> dataSplits = new ArrayList<Bytes>();
            for (int i = opts.getBucketsPerTablet(); i < opts.numBuckets; i += opts.getBucketsPerTablet()) {
                String bucketId = CollisionFreeMap.genBucketId(i, opts.numBuckets);
                rowBuilder.setLength(mapId.length());
                dataSplits.add(rowBuilder.append(":d:").append(bucketId).toBytes());
            }
            Collections.sort(dataSplits);
            ArrayList<Bytes> updateSplits = new ArrayList<Bytes>();
            for (int i = opts.getBucketsPerTablet(); i < opts.numBuckets; i += opts.getBucketsPerTablet()) {
                String bucketId = CollisionFreeMap.genBucketId(i, opts.numBuckets);
                rowBuilder.setLength(mapId.length());
                updateSplits.add(rowBuilder.append(":u:").append(bucketId).toBytes());
            }
            Collections.sort(updateSplits);
            Bytes dataRangeEnd = Bytes.of((String)(opts.mapId + CollisionFreeMap.DATA_RANGE_END));
            Bytes updateRangeEnd = Bytes.of((String)(opts.mapId + CollisionFreeMap.UPDATE_RANGE_END));
            ArrayList<Bytes> splits = new ArrayList<Bytes>();
            splits.add(dataRangeEnd);
            splits.add(updateRangeEnd);
            splits.addAll(dataSplits);
            splits.addAll(updateSplits);
            TableOptimizations tableOptim = new TableOptimizations();
            tableOptim.setSplits(splits);
            tableOptim.setTabletGroupingRegex(Pattern.quote(mapId + ":") + "[du]:");
            return tableOptim;
        }
    }

    public static class Options {
        static final long DEFAULT_BUFFER_SIZE = 0x400000L;
        static final int DEFAULT_BUCKETS_PER_TABLET = 10;
        int numBuckets;
        Integer bucketsPerTablet = null;
        Long bufferSize;
        String keyType;
        String valueType;
        String combinerType;
        String updateObserverType;
        String mapId;
        private static final String PREFIX = "recipes.cfm.";

        Options(String mapId, SimpleConfiguration appConfig) {
            this.mapId = mapId;
            this.numBuckets = appConfig.getInt(PREFIX + mapId + ".buckets");
            this.combinerType = appConfig.getString(PREFIX + mapId + ".combiner");
            this.keyType = appConfig.getString(PREFIX + mapId + ".key");
            this.valueType = appConfig.getString(PREFIX + mapId + ".val");
            this.updateObserverType = appConfig.getString(PREFIX + mapId + ".updateObserver", null);
            this.bufferSize = appConfig.getLong(PREFIX + mapId + ".bufferSize", 0x400000L);
            this.bucketsPerTablet = appConfig.getInt(PREFIX + mapId + ".bucketsPerTablet", 10);
        }

        public Options(String mapId, String combinerType, String keyType, String valType, int buckets) {
            Preconditions.checkArgument((buckets > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((!mapId.contains(":") ? 1 : 0) != 0, (Object)"Map id cannot contain ':'");
            this.mapId = mapId;
            this.numBuckets = buckets;
            this.combinerType = combinerType;
            this.updateObserverType = null;
            this.keyType = keyType;
            this.valueType = valType;
        }

        public Options(String mapId, String combinerType, String updateObserverType, String keyType, String valueType, int buckets) {
            Preconditions.checkArgument((buckets > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((!mapId.contains(":") ? 1 : 0) != 0, (Object)"Map id cannot contain ':'");
            this.mapId = mapId;
            this.numBuckets = buckets;
            this.combinerType = combinerType;
            this.updateObserverType = updateObserverType;
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public Options setBufferSize(long bufferSize) {
            Preconditions.checkArgument((bufferSize > 0L ? 1 : 0) != 0, (Object)"Buffer size must be positive");
            this.bufferSize = bufferSize;
            return this;
        }

        long getBufferSize() {
            if (this.bufferSize == null) {
                return 0x400000L;
            }
            return this.bufferSize;
        }

        public Options setBucketsPerTablet(int bucketsPerTablet) {
            Preconditions.checkArgument((bucketsPerTablet > 0 ? 1 : 0) != 0, (Object)("bucketsPerTablet is <= 0 : " + bucketsPerTablet));
            this.bucketsPerTablet = bucketsPerTablet;
            return this;
        }

        int getBucketsPerTablet() {
            if (this.bucketsPerTablet == null) {
                return 10;
            }
            return this.bucketsPerTablet;
        }

        public <K, V> Options(String mapId, Class<? extends Combiner<K, V>> combiner, Class<K> keyType, Class<V> valueType, int buckets) {
            this(mapId, combiner.getName(), keyType.getName(), valueType.getName(), buckets);
        }

        public <K, V> Options(String mapId, Class<? extends Combiner<K, V>> combiner, Class<? extends UpdateObserver<K, V>> updateObserver, Class<K> keyType, Class<V> valueType, int buckets) {
            this(mapId, combiner.getName(), updateObserver.getName(), keyType.getName(), valueType.getName(), buckets);
        }

        void save(SimpleConfiguration appConfig) {
            appConfig.setProperty(PREFIX + this.mapId + ".buckets", this.numBuckets + "");
            appConfig.setProperty(PREFIX + this.mapId + ".combiner", this.combinerType + "");
            appConfig.setProperty(PREFIX + this.mapId + ".key", this.keyType);
            appConfig.setProperty(PREFIX + this.mapId + ".val", this.valueType);
            if (this.updateObserverType != null) {
                appConfig.setProperty(PREFIX + this.mapId + ".updateObserver", this.updateObserverType + "");
            }
            if (this.bufferSize != null) {
                appConfig.setProperty(PREFIX + this.mapId + ".bufferSize", this.bufferSize);
            }
            if (this.bucketsPerTablet != null) {
                appConfig.setProperty(PREFIX + this.mapId + ".bucketsPerTablet", this.bucketsPerTablet);
            }
        }
    }

    public static class Initializer<K2, V2>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String mapId;
        private SimpleSerializer serializer;
        private int numBuckets = -1;

        private Initializer(String mapId, int numBuckets, SimpleSerializer serializer) {
            this.mapId = mapId;
            this.numBuckets = numBuckets;
            this.serializer = serializer;
        }

        public RowColumnValue convert(K2 key, V2 val) {
            byte[] k = this.serializer.serialize(key);
            int hash = Hashing.murmur3_32().hashBytes(k).asInt();
            String bucketId = CollisionFreeMap.genBucketId(Math.abs(hash % this.numBuckets), this.numBuckets);
            Bytes.BytesBuilder bb = Bytes.builder();
            Bytes row = bb.append(this.mapId).append(":d:").append(bucketId).append(":").append(k).toBytes();
            byte[] v = this.serializer.serialize(val);
            return new RowColumnValue(row, DATA_COLUMN, Bytes.of((byte[])v));
        }
    }
}

