/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.recipes.core.export;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Iterator;
import org.apache.fluo.api.client.TransactionBase;
import org.apache.fluo.api.client.scanner.CellScanner;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.RowColumn;
import org.apache.fluo.api.data.RowColumnValue;
import org.apache.fluo.api.data.Span;
import org.apache.fluo.recipes.core.export.ExportEntry;
import org.apache.fluo.recipes.core.types.StringEncoder;
import org.apache.fluo.recipes.core.types.TypeLayer;
import org.apache.fluo.recipes.core.types.TypedTransactionBase;

class ExportBucket {
    private static final String NOTIFICATION_CF = "fluoRecipes";
    private static final String NOTIFICATION_CQ_PREFIX = "eq:";
    private static final Column EXPORT_COL = new Column((CharSequence)"e", (CharSequence)"v");
    private static final Column NEXT_COL = new Column((CharSequence)"e", (CharSequence)"next");
    private final TypedTransactionBase ttx;
    private final String qid;
    private final Bytes bucketRow;

    static Column newNotificationColumn(String queueId) {
        return new Column((CharSequence)NOTIFICATION_CF, (CharSequence)(NOTIFICATION_CQ_PREFIX + queueId));
    }

    static String genBucketId(int bucket, int maxBucket) {
        Preconditions.checkArgument((bucket >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxBucket > 0 ? 1 : 0) != 0);
        int bits = 32 - Integer.numberOfLeadingZeros(maxBucket);
        int bucketLen = bits / 4 + (bits % 4 > 0 ? 1 : 0);
        return Strings.padStart((String)Integer.toHexString(bucket), (int)bucketLen, (char)'0');
    }

    static Bytes generateBucketRow(String qid, int bucket, int numBuckets) {
        return Bytes.of((String)(qid + ":" + ExportBucket.genBucketId(bucket, numBuckets)));
    }

    ExportBucket(TransactionBase tx, String qid, int bucket, int numBuckets) {
        Preconditions.checkArgument((!qid.contains(":") ? 1 : 0) != 0, (Object)"Export QID can not contain :");
        this.ttx = new TypeLayer(new StringEncoder()).wrap(tx);
        this.qid = qid;
        this.bucketRow = ExportBucket.generateBucketRow(qid, bucket, numBuckets);
    }

    ExportBucket(TransactionBase tx, Bytes bucketRow) {
        this.ttx = new TypeLayer(new StringEncoder()).wrap(tx);
        int colonLoc = -1;
        for (int i = 0; i < bucketRow.length(); ++i) {
            if (bucketRow.byteAt(i) != 58) continue;
            colonLoc = i;
            break;
        }
        Preconditions.checkArgument((colonLoc != -1 && colonLoc != bucketRow.length() ? 1 : 0) != 0, (Object)("Invalid bucket row " + bucketRow));
        Preconditions.checkArgument((bucketRow.byteAt(bucketRow.length() - 1) == 58 ? 1 : 0) != 0, (Object)("Invalid bucket row " + bucketRow));
        this.bucketRow = bucketRow.subSequence(0, bucketRow.length() - 1);
        this.qid = bucketRow.subSequence(0, colonLoc).toString();
    }

    private static byte[] encSeq(long l) {
        byte[] ret = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)(l >>> 0)};
        return ret;
    }

    private static long decodeSeq(Bytes seq) {
        return ((long)seq.byteAt(0) << 56) + ((long)(seq.byteAt(1) & 0xFF) << 48) + ((long)(seq.byteAt(2) & 0xFF) << 40) + ((long)(seq.byteAt(3) & 0xFF) << 32) + ((long)(seq.byteAt(4) & 0xFF) << 24) + (long)((seq.byteAt(5) & 0xFF) << 16) + (long)((seq.byteAt(6) & 0xFF) << 8) + (long)((seq.byteAt(7) & 0xFF) << 0);
    }

    public void add(long seq, byte[] key, byte[] value) {
        Bytes row = Bytes.builder((int)(this.bucketRow.length() + 1 + key.length + 8)).append(this.bucketRow).append(":").append(key).append(ExportBucket.encSeq(seq)).toBytes();
        this.ttx.set(row, EXPORT_COL, Bytes.of((byte[])value));
    }

    private Bytes getMinimalRow() {
        return Bytes.builder((int)(this.bucketRow.length() + 1)).append(this.bucketRow).append(":").toBytes();
    }

    public void notifyExportObserver() {
        ((TypedTransactionBase.Mutator)((TypedTransactionBase.MutatorFamilyMethods)this.ttx.mutate().row(this.getMinimalRow())).col(ExportBucket.newNotificationColumn(this.qid))).weaklyNotify();
    }

    public Iterator<ExportEntry> getExportIterator(Bytes continueRow) {
        Span span;
        if (continueRow != null) {
            Span nextSpan;
            Span tmpSpan = Span.prefix((Bytes)this.bucketRow);
            span = nextSpan = new Span(new RowColumn(continueRow, EXPORT_COL), true, tmpSpan.getEnd(), tmpSpan.isEndInclusive());
        } else {
            span = Span.prefix((Bytes)this.bucketRow);
        }
        CellScanner scanner = this.ttx.scanner().over(span).fetch(new Column[]{EXPORT_COL}).build();
        return new ExportIterator(scanner);
    }

    public Bytes getContinueRow() {
        return this.ttx.get(this.getMinimalRow(), NEXT_COL);
    }

    public void setContinueRow(ExportEntry ee) {
        Bytes nextRow = Bytes.builder((int)(this.bucketRow.length() + 1 + ee.key.length + 8)).append(this.bucketRow).append(":").append(ee.key).append(ExportBucket.encSeq(ee.seq)).toBytes();
        this.ttx.set(this.getMinimalRow(), NEXT_COL, nextRow);
    }

    public void clearContinueRow() {
        this.ttx.delete(this.getMinimalRow(), NEXT_COL);
    }

    private class ExportIterator
    implements Iterator<ExportEntry> {
        private Iterator<RowColumnValue> rowIter;
        private Bytes lastRow;

        public ExportIterator(CellScanner scanner) {
            this.rowIter = scanner.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.rowIter.hasNext();
        }

        @Override
        public ExportEntry next() {
            RowColumnValue rowColVal = this.rowIter.next();
            Bytes row = rowColVal.getRow();
            Bytes keyBytes = row.subSequence(ExportBucket.this.bucketRow.length() + 1, row.length() - 8);
            Bytes seqBytes = row.subSequence(row.length() - 8, row.length());
            ExportEntry ee = new ExportEntry();
            ee.key = keyBytes.toArray();
            ee.seq = ExportBucket.decodeSeq(seqBytes);
            ee.value = rowColVal.getValue().toArray();
            this.lastRow = row;
            return ee;
        }

        @Override
        public void remove() {
            ((TypedTransactionBase.Mutator)((TypedTransactionBase.MutatorFamilyMethods)ExportBucket.this.ttx.mutate().row(this.lastRow)).col(EXPORT_COL)).delete();
        }
    }
}

