/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.recipes.core.data;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.recipes.core.common.TableOptimizations;

public class RowHasher {
    private static final int HASH_LEN = 4;
    private static final String PREFIX = "recipes.rowHasher.";
    private ThreadLocal<Bytes.BytesBuilder> builders;
    private Bytes prefixBytes;
    private String prefix;

    public static void configure(FluoConfiguration fluoConfig, String prefix, int numTablets) {
        fluoConfig.getAppConfiguration().setProperty(PREFIX + prefix + ".numTablets", Integer.valueOf(numTablets));
        TableOptimizations.registerOptimization(fluoConfig.getAppConfiguration(), prefix, Optimizer.class);
    }

    public RowHasher(String prefix) {
        this.prefix = prefix;
        this.prefixBytes = Bytes.of((String)(prefix + ":"));
        this.builders = ThreadLocal.withInitial(() -> {
            Bytes.BytesBuilder bb = Bytes.builder((int)(this.prefixBytes.length() + 5 + 32));
            bb.append(this.prefixBytes);
            return bb;
        });
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Bytes addHash(String row) {
        return this.addHash(Bytes.of((String)row));
    }

    public Bytes addHash(Bytes row) {
        Bytes.BytesBuilder builder = this.builders.get();
        builder.setLength(this.prefixBytes.length());
        builder.append(RowHasher.genHash(row));
        builder.append(":");
        builder.append(row);
        return builder.toBytes();
    }

    private boolean hasHash(Bytes row) {
        for (int i = this.prefixBytes.length(); i < this.prefixBytes.length() + 4; ++i) {
            boolean isAlphaNum;
            byte b = row.byteAt(i);
            boolean bl = isAlphaNum = b >= 97 && b <= 122 || b >= 48 && b <= 57;
            if (isAlphaNum) continue;
            return false;
        }
        return row.byteAt(this.prefixBytes.length() - 1) == 58 && row.byteAt(this.prefixBytes.length() + 4) == 58;
    }

    public Bytes removeHash(Bytes row) {
        Preconditions.checkArgument((row.length() >= this.prefixBytes.length() + 5 ? 1 : 0) != 0, (Object)("Row is shorter than expected " + row));
        Preconditions.checkArgument((boolean)row.subSequence(0, this.prefixBytes.length()).equals((Object)this.prefixBytes), (Object)("Row does not have expected prefix " + row));
        Preconditions.checkArgument((boolean)this.hasHash(row), (Object)("Row does not have expected hash " + row));
        return row.subSequence(this.prefixBytes.length() + 5, row.length());
    }

    private static String genHash(Bytes row) {
        int hash = Hashing.murmur3_32().hashBytes(row.toArray()).asInt();
        String hashString = Strings.padStart((String)Integer.toString(hash &= Integer.MAX_VALUE, 36), (int)4, (char)'0');
        hashString = hashString.substring(hashString.length() - 4);
        return hashString;
    }

    public static class Optimizer
    implements TableOptimizations.TableOptimizationsFactory {
        @Override
        public TableOptimizations getTableOptimizations(String key, SimpleConfiguration appConfig) {
            int distance;
            int numTablets = appConfig.getInt(RowHasher.PREFIX + key + ".numTablets");
            String prefix = key + ":";
            ArrayList<Bytes> splits = new ArrayList<Bytes>(numTablets - 1);
            int numSplits = numTablets - 1;
            int split = distance = ((int)Math.pow(36.0, 4.0) - 1) / numTablets + 1;
            for (int i = 0; i < numSplits; ++i) {
                splits.add(Bytes.of((String)(prefix + Strings.padStart((String)Integer.toString(split, 36), (int)4, (char)'0'))));
                split += distance;
            }
            splits.add(Bytes.of((String)(prefix + "~")));
            TableOptimizations tableOptim = new TableOptimizations();
            tableOptim.setSplits(splits);
            tableOptim.setTabletGroupingRegex(Pattern.quote(prefix.toString()));
            return tableOptim;
        }
    }
}

