/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.recipes.core.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.recipes.core.common.RowRange;

public class TransientRegistry {
    private SimpleConfiguration appConfig;
    private static final String PREFIX = "recipes.transientRange.";

    public TransientRegistry(SimpleConfiguration appConfig) {
        this.appConfig = appConfig;
    }

    public void addTransientRange(String id, RowRange range) {
        String start = DatatypeConverter.printHexBinary((byte[])range.getStart().toArray());
        String end = DatatypeConverter.printHexBinary((byte[])range.getEnd().toArray());
        this.appConfig.setProperty(PREFIX + id, start + ":" + end);
    }

    public List<RowRange> getTransientRanges() {
        ArrayList<RowRange> ranges = new ArrayList<RowRange>();
        Iterator keys = this.appConfig.getKeys(PREFIX.substring(0, PREFIX.length() - 1));
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String val = this.appConfig.getString(key);
            String[] sa = val.split(":");
            RowRange rowRange = new RowRange(Bytes.of((byte[])DatatypeConverter.parseHexBinary((String)sa[0])), Bytes.of((byte[])DatatypeConverter.parseHexBinary((String)sa[1])));
            ranges.add(rowRange);
        }
        return ranges;
    }
}

