/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.recipes.core.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.fluo.api.client.FluoClient;
import org.apache.fluo.api.client.FluoFactory;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.api.data.Bytes;

public class TableOptimizations {
    private List<Bytes> splits = new ArrayList<Bytes>();
    private String tabletGroupingRegex = "";
    private static final String PREFIX = "recipes.optimizations.";

    public void setSplits(List<Bytes> splits) {
        this.splits.clear();
        this.splits.addAll(splits);
    }

    public List<Bytes> getSplits() {
        return Collections.unmodifiableList(this.splits);
    }

    public void setTabletGroupingRegex(String tgr) {
        Objects.requireNonNull(tgr);
        this.tabletGroupingRegex = tgr;
    }

    public String getTabletGroupingRegex() {
        return "(" + this.tabletGroupingRegex + ").*";
    }

    public void merge(TableOptimizations other) {
        this.splits.addAll(other.splits);
        this.tabletGroupingRegex = this.tabletGroupingRegex.length() > 0 && other.tabletGroupingRegex.length() > 0 ? this.tabletGroupingRegex + "|" + other.tabletGroupingRegex : this.tabletGroupingRegex + other.tabletGroupingRegex;
    }

    public static void registerOptimization(SimpleConfiguration appConfig, String key, Class<? extends TableOptimizationsFactory> clazz) {
        appConfig.setProperty(PREFIX + key, clazz.getName());
    }

    public static TableOptimizations getConfiguredOptimizations(FluoConfiguration fluoConfig) {
        try (FluoClient client = FluoFactory.newClient((SimpleConfiguration)fluoConfig);){
            SimpleConfiguration appConfig = client.getAppConfiguration();
            TableOptimizations tableOptim = new TableOptimizations();
            SimpleConfiguration subset = appConfig.subset(PREFIX.substring(0, PREFIX.length() - 1));
            Iterator keys = subset.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String clazz = subset.getString(key);
                try {
                    TableOptimizationsFactory factory = Class.forName(clazz).asSubclass(TableOptimizationsFactory.class).newInstance();
                    tableOptim.merge(factory.getTableOptimizations(key, appConfig));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
            TableOptimizations tableOptimizations = tableOptim;
            return tableOptimizations;
        }
    }

    public static interface TableOptimizationsFactory {
        public TableOptimizations getTableOptimizations(String var1, SimpleConfiguration var2);
    }
}

