/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.recipes.core.common;

import java.util.Objects;
import org.apache.fluo.api.data.Bytes;

public class RowRange {
    private final Bytes start;
    private final Bytes end;

    public RowRange(Bytes start, Bytes end) {
        Objects.requireNonNull(start);
        Objects.requireNonNull(end);
        this.start = start;
        this.end = end;
    }

    public Bytes getStart() {
        return this.start;
    }

    public Bytes getEnd() {
        return this.end;
    }

    public int hashCode() {
        return this.start.hashCode() + 31 * this.end.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof RowRange) {
            RowRange or = (RowRange)o;
            return this.start.equals((Object)or.start) && this.end.equals((Object)or.end);
        }
        return false;
    }

    private static void encNonAscii(StringBuilder sb, Bytes bytes) {
        if (bytes == null) {
            sb.append("null");
        } else {
            for (int i = 0; i < bytes.length(); ++i) {
                byte b = bytes.byteAt(i);
                if (b >= 32 && b <= 126 && b != 92) {
                    sb.append((char)b);
                    continue;
                }
                sb.append(String.format("\\x%02x", b & 0xFF));
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        RowRange.encNonAscii(sb, this.start);
        sb.append(", ");
        RowRange.encNonAscii(sb, this.end);
        sb.append("]");
        return sb.toString();
    }
}

