/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.worker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Range;
import org.apache.fluo.core.impl.Environment;
import org.apache.hadoop.io.Text;

public class TabletInfoCache<T, S extends Supplier<T>> {
    private static final long CACHE_TIME = 300000L;
    private final Environment env;
    private List<TabletInfo<T>> cachedTablets;
    private long listSplitsTime = 0L;
    private S supplier;

    public TabletInfoCache(Environment env, S supplier) {
        this.env = env;
        this.supplier = supplier;
    }

    private List<TabletInfo<T>> listSplits() throws TableNotFoundException, AccumuloSecurityException, AccumuloException {
        ArrayList splits = new ArrayList(this.env.getConnector().tableOperations().listSplits(this.env.getTable()));
        Collections.sort(splits);
        ArrayList<TabletInfo<T>> tablets = new ArrayList<TabletInfo<T>>(splits.size() + 1);
        for (int i = 0; i < splits.size(); ++i) {
            tablets.add(new TabletInfo(i == 0 ? null : (Text)splits.get(i - 1), (Text)splits.get(i), this.supplier.get()));
        }
        tablets.add(new TabletInfo(splits.size() == 0 ? null : (Text)splits.get(splits.size() - 1), null, this.supplier.get()));
        this.listSplitsTime = System.currentTimeMillis();
        return tablets;
    }

    public synchronized List<TabletInfo<T>> getTablets() throws Exception {
        if (this.cachedTablets == null) {
            this.cachedTablets = this.listSplits();
        } else if (System.currentTimeMillis() - this.listSplitsTime > 300000L) {
            List<TabletInfo<T>> tablets = this.listSplits();
            HashMap<TabletInfo<T>, TabletInfo<T>> oldTablets = new HashMap<TabletInfo<T>, TabletInfo<T>>();
            for (TabletInfo<T> tabletInfo : this.cachedTablets) {
                oldTablets.put(tabletInfo, tabletInfo);
            }
            ArrayList<TabletInfo<T>> newTablets = new ArrayList<TabletInfo<T>>(tablets.size());
            for (TabletInfo<T> tabletInfo : tablets) {
                TabletInfo oldTI = (TabletInfo)oldTablets.get(tabletInfo);
                if (oldTI != null) {
                    newTablets.add(oldTI);
                    continue;
                }
                newTablets.add(tabletInfo);
            }
            this.cachedTablets = newTablets;
        }
        return Collections.unmodifiableList(this.cachedTablets);
    }

    public static class TabletInfo<T> {
        private final Text start;
        private final Text end;
        private T data;

        TabletInfo(Text start, Text end, T data) {
            this.start = start;
            this.end = end;
            this.data = data;
        }

        private int hashCode(Text t) {
            if (t == null) {
                return 0;
            }
            return t.hashCode();
        }

        public int hashCode() {
            return this.hashCode(this.start) + this.hashCode(this.end);
        }

        private boolean equals(Text t1, Text t2) {
            if (t1 == t2) {
                return true;
            }
            if (t1 == null || t2 == null) {
                return false;
            }
            return t1.equals((Object)t2);
        }

        public boolean equals(Object o) {
            if (o instanceof TabletInfo) {
                TabletInfo oti = (TabletInfo)o;
                if (this.equals(this.start, oti.start)) {
                    return this.equals(this.end, oti.end);
                }
                return false;
            }
            return false;
        }

        public Text getStart() {
            return this.start;
        }

        public Text getEnd() {
            return this.end;
        }

        public T getData() {
            return this.data;
        }

        public Range getRange() {
            return new Range(this.start, false, this.end, true);
        }
    }
}

