/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.worker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.fluo.api.config.ObserverSpecification;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.observer.Observer;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.worker.ObserverContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Observers
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Observers.class);
    private Environment env;
    Map<Column, List<Observer>> observers = new HashMap<Column, List<Observer>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Observer> getObserverList(Column col) {
        List<Observer> observerList;
        Map<Column, List<Observer>> map = this.observers;
        synchronized (map) {
            observerList = this.observers.get(col);
            if (observerList == null) {
                observerList = new ArrayList<Observer>();
                this.observers.put(col, observerList);
            }
        }
        return observerList;
    }

    public Observers(Environment env) {
        this.env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Observer getObserver(Column col) {
        List<Observer> observerList;
        List<Observer> list = observerList = this.getObserverList(col);
        synchronized (list) {
            if (observerList.size() > 0) {
                return observerList.remove(observerList.size() - 1);
            }
        }
        Observer observer = null;
        ObserverSpecification observerConfig = this.env.getObservers().get(col);
        if (observerConfig == null) {
            observerConfig = this.env.getWeakObservers().get(col);
        }
        if (observerConfig != null) {
            try {
                observer = Class.forName(observerConfig.getClassName()).asSubclass(Observer.class).newInstance();
                observer.init((Observer.Context)new ObserverContext(this.env, observerConfig.getConfiguration()));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!observer.getObservedColumn().getColumn().equals((Object)col)) {
                throw new IllegalStateException("Mismatch between configured column and class column " + observerConfig.getClassName() + " " + col + " " + observer.getObservedColumn().getColumn());
            }
        }
        return observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObserver(Observer observer) {
        List<Observer> olist;
        List<Observer> list = olist = this.getObserverList(observer.getObservedColumn().getColumn());
        synchronized (list) {
            olist.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.observers == null) {
            return;
        }
        Map<Column, List<Observer>> map = this.observers;
        synchronized (map) {
            Iterator<List<Observer>> iterator = this.observers.values().iterator();
            while (iterator.hasNext()) {
                List<Observer> olist;
                List<Observer> list = olist = iterator.next();
                synchronized (list) {
                    for (Observer observer : olist) {
                        try {
                            observer.close();
                        }
                        catch (Exception e) {
                            log.error("Failed to close observer", (Throwable)e);
                        }
                    }
                    olist.clear();
                }
            }
        }
        this.observers = null;
    }
}

