/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.worker;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Objects;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.exceptions.FluoException;
import org.apache.fluo.api.service.FluoWorker;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.metrics.ReporterUtil;
import org.apache.fluo.core.util.CuratorUtil;
import org.apache.fluo.core.util.UtilWaitThread;
import org.apache.fluo.core.worker.NotificationFinder;
import org.apache.fluo.core.worker.NotificationFinderFactory;
import org.apache.fluo.core.worker.NotificationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluoWorkerImpl
implements FluoWorker {
    private static final Logger log = LoggerFactory.getLogger(FluoWorkerImpl.class);
    private FluoConfiguration config;
    private Environment env;
    private AutoCloseable reporters;
    private NotificationProcessor np;
    private NotificationFinder notificationFinder;
    private NodeCache appIdCache;

    public FluoWorkerImpl(FluoConfiguration config) {
        Objects.requireNonNull(config);
        Preconditions.checkArgument((boolean)config.hasRequiredWorkerProps());
        this.config = config;
    }

    public void start() {
        try {
            this.env = new Environment(this.config);
            this.reporters = ReporterUtil.setupReporters(this.env);
            this.appIdCache = CuratorUtil.startAppIdWatcher(this.env);
            log.info("Starting Worker for Fluo '{}' application with the following configuration:", (Object)this.config.getApplicationName());
            this.env.getConfiguration().print();
            this.np = new NotificationProcessor(this.env);
            this.notificationFinder = NotificationFinderFactory.newNotificationFinder(this.env.getConfiguration());
            this.notificationFinder.init(this.env, this.np);
            this.notificationFinder.start();
        }
        catch (Exception e) {
            throw new FluoException((Throwable)e);
        }
    }

    public void stop() {
        try {
            this.notificationFinder.stop();
            this.np.close();
            this.appIdCache.close();
            this.reporters.close();
            this.env.close();
        }
        catch (Exception e) {
            throw new FluoException((Throwable)e);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: FluoWorkerImpl <fluoPropsPath>");
            System.exit(-1);
        }
        String propsPath = args[0];
        Objects.requireNonNull(propsPath);
        File propsFile = new File(propsPath);
        if (!propsFile.exists()) {
            System.err.println("ERROR - Fluo properties file does not exist: " + propsPath);
            System.exit(-1);
        }
        Preconditions.checkArgument((boolean)propsFile.exists());
        try {
            FluoConfiguration config = new FluoConfiguration(propsFile);
            FluoWorkerImpl worker = new FluoWorkerImpl(config);
            worker.start();
            while (true) {
                UtilWaitThread.sleep(10000L);
            }
        }
        catch (Exception e) {
            log.error("Exception running FluoWorker: ", (Throwable)e);
            return;
        }
    }
}

