/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilWaitThread {
    private static final Logger log = LoggerFactory.getLogger(UtilWaitThread.class);

    private UtilWaitThread() {
    }

    public static void sleep(long millis, AtomicBoolean skipLog) {
        if (millis == 0L) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            if (!skipLog.get()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            Thread.currentThread().interrupt();
        }
    }

    public static void sleep(long millis) {
        UtilWaitThread.sleep(millis, new AtomicBoolean(false));
    }
}

