/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.util;

import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.RowColumn;
import org.apache.fluo.api.data.Span;
import org.apache.fluo.core.util.ByteUtil;
import org.apache.hadoop.io.Text;

public class SpanUtil {
    private SpanUtil() {
    }

    public static Range toRange(Span span) {
        return new Range(SpanUtil.toKey(span.getStart()), span.isStartInclusive(), SpanUtil.toKey(span.getEnd()), span.isEndInclusive());
    }

    public static Key toKey(RowColumn rc) {
        if (rc == null || rc.getRow().equals((Object)Bytes.EMPTY)) {
            return null;
        }
        Text row = ByteUtil.toText(rc.getRow());
        if (rc.getColumn().equals((Object)Column.EMPTY) || !rc.getColumn().isFamilySet()) {
            return new Key(row);
        }
        Text cf = ByteUtil.toText(rc.getColumn().getFamily());
        if (!rc.getColumn().isQualifierSet()) {
            return new Key(row, cf);
        }
        Text cq = ByteUtil.toText(rc.getColumn().getQualifier());
        if (!rc.getColumn().isVisibilitySet()) {
            return new Key(row, cf, cq);
        }
        Text cv = ByteUtil.toText(rc.getColumn().getVisibility());
        return new Key(row, cf, cq, cv);
    }

    public static Span toSpan(Range range) {
        return new Span(SpanUtil.toRowColumn(range.getStartKey()), range.isStartKeyInclusive(), SpanUtil.toRowColumn(range.getEndKey()), range.isEndKeyInclusive());
    }

    public static RowColumn toRowColumn(Key key) {
        if (key == null) {
            return RowColumn.EMPTY;
        }
        if (key.getRow() == null || key.getRow().getLength() == 0) {
            return RowColumn.EMPTY;
        }
        Bytes row = ByteUtil.toBytes(key.getRow());
        if (key.getColumnFamily() == null || key.getColumnFamily().getLength() == 0) {
            return new RowColumn(row);
        }
        Bytes cf = ByteUtil.toBytes(key.getColumnFamily());
        if (key.getColumnQualifier() == null || key.getColumnQualifier().getLength() == 0) {
            return new RowColumn(row, new Column(cf));
        }
        Bytes cq = ByteUtil.toBytes(key.getColumnQualifier());
        if (key.getColumnVisibility() == null || key.getColumnVisibility().getLength() == 0) {
            return new RowColumn(row, new Column(cf, cq));
        }
        Bytes cv = ByteUtil.toBytes(key.getColumnVisibility());
        return new RowColumn(row, new Column(cf, cq, cv));
    }
}

