/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.util;

import com.google.common.base.Preconditions;

public class Limit {
    int permits;
    int leased = 0;

    public Limit(int permits) {
        this.permits = permits;
    }

    public synchronized void acquire(int num) {
        Preconditions.checkArgument((num >= 0 ? 1 : 0) != 0, (String)"num < 0 : %s", (Object[])new Object[]{num});
        while (this.leased >= this.permits) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.leased += num;
        if (this.leased < this.permits) {
            this.notify();
        }
    }

    public synchronized void release(int num) {
        Preconditions.checkArgument((num <= this.leased ? 1 : 0) != 0, (String)"relasing more than leased %s > %s", (Object[])new Object[]{num, this.leased});
        this.leased -= num;
        if (this.leased < this.permits) {
            this.notify();
        }
    }

    public synchronized int leased() {
        return this.leased;
    }
}

