/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.util;

import org.apache.fluo.core.util.UtilWaitThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Halt {
    private static final Marker fatal = MarkerFactory.getMarker((String)"FATAL");
    private static final Logger log = LoggerFactory.getLogger(Halt.class);

    private Halt() {
    }

    public static void halt(final String msg) {
        Halt.halt(0, new Runnable(){

            @Override
            public void run() {
                log.error(fatal, msg);
            }
        });
    }

    public static void halt(final String msg, int status) {
        Halt.halt(status, new Runnable(){

            @Override
            public void run() {
                log.error(fatal, msg);
            }
        });
    }

    public static void halt(final int status, Runnable runnable) {
        try {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    UtilWaitThread.sleep(100L);
                    Runtime.getRuntime().halt(status);
                }
            };
            thread.setDaemon(true);
            thread.start();
            if (runnable != null) {
                runnable.run();
            }
            Runtime.getRuntime().halt(status);
        }
        finally {
            Runtime.getRuntime().halt(-1);
        }
    }
}

