/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class FluoThreadFactory
implements ThreadFactory {
    private static AtomicInteger poolCount = new AtomicInteger();
    private AtomicInteger threadCount = new AtomicInteger();
    private String poolName;
    private int poolId;

    public FluoThreadFactory(String poolName) {
        this.poolName = poolName;
        this.poolId = poolCount.incrementAndGet();
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r);
        String name = String.format("Fluo-%04d-%03d-%s", this.poolId, this.threadCount.incrementAndGet(), this.poolName);
        t.setName(name);
        t.setDaemon(true);
        return t;
    }
}

