/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.fluo.core.util.FluoThreadFactory;
import org.slf4j.LoggerFactory;

public class FluoExecutors {
    public static ExecutorService newFixedThreadPool(int numThreads, String name) {
        return FluoExecutors.newFixedThreadPool(numThreads, new LinkedBlockingQueue<Runnable>(), name);
    }

    public static ThreadPoolExecutor newFixedThreadPool(int numThreads, BlockingQueue<Runnable> queue, String name) {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)queue, (ThreadFactory)new FluoThreadFactory(name)){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                if (t != null) {
                    if (t instanceof Exception) {
                        LoggerFactory.getLogger(FluoExecutors.class).warn("Thread pool saw uncaught Exception", t);
                    } else {
                        System.err.println("Threadpool saw uncaught Throwable");
                        t.printStackTrace();
                    }
                }
            }
        };
        return tpe;
    }
}

