/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.util;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.recipes.nodes.PersistentEphemeralNode;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.fluo.accumulo.util.ZookeeperUtil;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.util.Halt;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorUtil {
    private static final Logger log = LoggerFactory.getLogger(CuratorUtil.class);

    private CuratorUtil() {
    }

    public static CuratorFramework newAppCurator(FluoConfiguration config) {
        return CuratorUtil.newCurator(config.getAppZookeepers(), config.getZookeeperTimeout());
    }

    public static CuratorFramework newFluoCurator(FluoConfiguration config) {
        return CuratorUtil.newCurator(config.getInstanceZookeepers(), config.getZookeeperTimeout());
    }

    public static CuratorFramework newRootFluoCurator(FluoConfiguration config) {
        return CuratorUtil.newCurator(ZookeeperUtil.parseServers((String)config.getInstanceZookeepers()), config.getZookeeperTimeout());
    }

    public static CuratorFramework newCurator(String zookeepers, int timeout) {
        return CuratorFrameworkFactory.newClient((String)zookeepers, (int)timeout, (int)timeout, (RetryPolicy)new ExponentialBackoffRetry(1000, 10));
    }

    public static boolean putData(CuratorFramework curator, String zPath, byte[] data, NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        if (policy == null) {
            policy = NodeExistsPolicy.FAIL;
        }
        block8: while (true) {
            try {
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)curator.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(zPath, data);
                return true;
            }
            catch (Exception nee) {
                if (nee instanceof KeeperException.NodeExistsException) {
                    switch (policy) {
                        case SKIP: {
                            return false;
                        }
                        case OVERWRITE: {
                            try {
                                ((BackgroundPathAndBytesable)curator.setData().withVersion(-1)).forPath(zPath, data);
                                return true;
                            }
                            catch (Exception nne) {
                                if (nne instanceof KeeperException.NoNodeException) continue block8;
                                throw new RuntimeException(nne);
                            }
                        }
                    }
                    throw (KeeperException.NodeExistsException)nee;
                }
                throw new RuntimeException(nee);
            }
            break;
        }
    }

    public static void startAndWait(PersistentEphemeralNode node, int maxWaitSec) {
        node.start();
        int waitTime = 0;
        try {
            while (!node.waitForInitialCreate(1L, TimeUnit.SECONDS)) {
                log.info("Waited " + ++waitTime + " sec for ephemeral node to be created");
                if (waitTime <= maxWaitSec) continue;
                throw new IllegalStateException("Failed to create ephemeral node");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static NodeCache startAppIdWatcher(Environment env) {
        try {
            CuratorFramework curator = env.getSharedResources().getCurator();
            byte[] uuidBytes = (byte[])curator.getData().forPath("/config/fluo.application.id");
            if (uuidBytes == null) {
                Halt.halt("Fluo Application UUID not found");
                throw new RuntimeException();
            }
            final String uuid = new String(uuidBytes, StandardCharsets.UTF_8);
            final NodeCache nodeCache = new NodeCache(curator, "/config/fluo.application.id");
            nodeCache.getListenable().addListener((Object)new NodeCacheListener(){

                public void nodeChanged() throws Exception {
                    ChildData node = nodeCache.getCurrentData();
                    if (node == null || !uuid.equals(new String(node.getData(), StandardCharsets.UTF_8))) {
                        Halt.halt("Fluo Application UUID has changed or disappeared");
                    }
                }
            });
            nodeCache.start();
            return nodeCache;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum NodeExistsPolicy {
        SKIP,
        OVERWRITE,
        FAIL;

    }
}

