/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.util;

import com.google.common.base.Preconditions;

public class Counter {
    private int count;

    public synchronized void increment() {
        ++this.count;
    }

    public synchronized void decrement() {
        Preconditions.checkArgument((this.count > 0 ? 1 : 0) != 0);
        --this.count;
        this.notifyAll();
    }

    public synchronized int get() {
        return this.count;
    }

    public synchronized void waitUntilZero() {
        while (this.count > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

