/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.fluo.accumulo.values.DelLockValue;
import org.apache.fluo.accumulo.values.WriteValue;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.Span;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.impl.TransactionImpl;
import org.apache.fluo.core.util.ByteUtil;
import org.apache.fluo.core.util.Flutation;
import org.apache.fluo.core.util.SpanUtil;

public class ColumnUtil {
    private ColumnUtil() {
    }

    static ColumnVisibility gv(Environment env, Column col) {
        return env.getSharedResources().getVisCache().getCV(col);
    }

    public static void commitColumn(Environment env, boolean isTrigger, boolean isPrimary, Column col, boolean isWrite, boolean isDelete, long startTs, long commitTs, Set<Column> observedColumns, Mutation m) {
        if (isWrite) {
            Flutation.put(env, m, col, 0x4000000000000000L | commitTs, WriteValue.encode((long)startTs, (boolean)isPrimary, (boolean)isDelete));
        } else {
            Flutation.put(env, m, col, 0x2000000000000000L | startTs, DelLockValue.encodeCommit((long)commitTs, (boolean)isPrimary));
        }
        if (isTrigger) {
            Flutation.put(env, m, col, 0xC000000000000000L | startTs, TransactionImpl.EMPTY);
        }
    }

    public static Map.Entry<Key, Value> checkColumn(Environment env, IteratorSetting iterConf, Bytes row, Column col) {
        Scanner scanner;
        Span span = Span.exact((Bytes)row, (Column)col);
        try {
            scanner = env.getConnector().createScanner(env.getTable(), env.getAuthorizations());
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
        scanner.setRange(SpanUtil.toRange(span));
        scanner.addScanIterator(iterConf);
        Iterator iter = scanner.iterator();
        if (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Key k = (Key)entry.getKey();
            Bytes r = Bytes.of((byte[])k.getRowData().toArray());
            Bytes cf = Bytes.of((byte[])k.getColumnFamilyData().toArray());
            Bytes cq = Bytes.of((byte[])k.getColumnQualifierData().toArray());
            Bytes cv = Bytes.of((byte[])k.getColumnVisibilityData().toArray());
            if (r.equals((Object)row) && cf.equals((Object)col.getFamily()) && cq.equals((Object)col.getQualifier()) && cv.equals((Object)col.getVisibility())) {
                return entry;
            }
            throw new RuntimeException("unexpected key " + k + " " + row + " " + col);
        }
        return null;
    }

    public static void writeColumn(Column col, DataOutputStream out) throws IOException {
        ByteUtil.write(out, col.getFamily());
        ByteUtil.write(out, col.getQualifier());
        ByteUtil.write(out, col.getVisibility());
    }

    public static Column readColumn(DataInputStream in) throws IOException {
        Bytes.BytesBuilder bb = Bytes.builder();
        Bytes family = ByteUtil.read(bb, in);
        Bytes qualifier = ByteUtil.read(bb, in);
        Bytes visibility = ByteUtil.read(bb, in);
        return new Column(family, qualifier, visibility);
    }
}

