/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.fluo.api.data.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;

public class ByteUtil {
    public static final byte[] EMPTY = new byte[0];

    private ByteUtil() {
    }

    public static Text toText(Bytes b) {
        return new Text(b.toArray());
    }

    public static Bytes toBytes(Text t) {
        return Bytes.of((byte[])t.getBytes(), (int)0, (int)t.getLength());
    }

    public static Bytes toBytes(ByteSequence bs) {
        if (bs.isBackedByArray()) {
            return Bytes.of((byte[])bs.getBackingArray(), (int)bs.offset(), (int)bs.length());
        }
        return Bytes.of((byte[])bs.toArray(), (int)0, (int)bs.length());
    }

    public static ByteSequence toByteSequence(Bytes b) {
        return new ArrayByteSequence(b.toArray());
    }

    public static byte[] toByteArray(Text text) {
        byte[] bytes = text.getBytes();
        if (bytes.length != text.getLength()) {
            bytes = new byte[text.getLength()];
            System.arraycopy(text.getBytes(), 0, bytes, 0, bytes.length);
        }
        return bytes;
    }

    public static void write(DataOutputStream out, Bytes b) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)b.length());
        b.writeTo((OutputStream)out);
    }

    public static Bytes read(Bytes.BytesBuilder bb, DataInputStream in) throws IOException {
        bb.setLength(0);
        int len = WritableUtils.readVInt((DataInput)in);
        bb.append((InputStream)in, len);
        return bb.toBytes();
    }
}

