/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.util;

import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.commons.configuration.Configuration;
import org.apache.fluo.api.config.FluoConfiguration;

public class AccumuloUtil {
    public static Instance getInstance(FluoConfiguration config) {
        ClientConfiguration clientConfig = new ClientConfiguration(new Configuration[0]).withInstance(config.getAccumuloInstance()).withZkHosts(config.getAccumuloZookeepers()).withZkTimeout(config.getZookeeperTimeout() / 1000);
        return new ZooKeeperInstance((Configuration)clientConfig);
    }

    public static Connector getConnector(FluoConfiguration config) {
        try {
            return AccumuloUtil.getInstance(config).getConnector(config.getAccumuloUser(), (AuthenticationToken)new PasswordToken((CharSequence)config.getAccumuloPassword()));
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

