/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.oracle;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Objects;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.exceptions.FluoException;
import org.apache.fluo.api.service.FluoOracle;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.metrics.ReporterUtil;
import org.apache.fluo.core.oracle.OracleServer;
import org.apache.fluo.core.util.CuratorUtil;
import org.apache.fluo.core.util.UtilWaitThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluoOracleImpl
implements FluoOracle {
    private static final Logger log = LoggerFactory.getLogger(FluoOracleImpl.class);
    private FluoConfiguration config;
    private Environment env;
    private AutoCloseable reporters;
    private OracleServer oracleServer;
    private NodeCache appIdCache;

    public FluoOracleImpl(FluoConfiguration config) {
        Objects.requireNonNull(config);
        Preconditions.checkArgument((boolean)config.hasRequiredOracleProps());
        config.setClientRetryTimeout(-1);
        try {
            config.validate();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid FluoConfiguration", e);
        }
        this.config = config;
    }

    public void start() {
        try {
            this.env = new Environment(this.config);
            this.reporters = ReporterUtil.setupReporters(this.env);
            this.appIdCache = CuratorUtil.startAppIdWatcher(this.env);
            log.info("Starting Oracle for Fluo '{}' application with the following configuration:", (Object)this.config.getApplicationName());
            this.env.getConfiguration().print();
            this.oracleServer = new OracleServer(this.env);
            this.oracleServer.start();
        }
        catch (Exception e) {
            throw new FluoException((Throwable)e);
        }
    }

    public void stop() {
        try {
            this.oracleServer.stop();
            this.appIdCache.close();
            this.reporters.close();
            this.env.close();
        }
        catch (Exception e) {
            throw new FluoException((Throwable)e);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: FluoOracleImpl <fluoPropsPath>");
            System.exit(-1);
        }
        String propsPath = args[0];
        Objects.requireNonNull(propsPath);
        File propsFile = new File(propsPath);
        if (!propsFile.exists()) {
            System.err.println("ERROR - Fluo properties file does not exist: " + propsPath);
            System.exit(-1);
        }
        Preconditions.checkArgument((boolean)propsFile.exists());
        try {
            FluoConfiguration config = new FluoConfiguration(propsFile);
            FluoOracleImpl oracle = new FluoOracleImpl(config);
            oracle.start();
            while (true) {
                UtilWaitThread.sleep(10000L);
            }
        }
        catch (Exception e) {
            log.error("Exception running FluoOracle: ", (Throwable)e);
            return;
        }
    }
}

