/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.metrics.starters;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.core.metrics.ReporterStarter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jReporterStarter
implements ReporterStarter {
    private static final Logger log = LoggerFactory.getLogger(Slf4jReporterStarter.class);

    @Override
    public List<AutoCloseable> start(ReporterStarter.Params params) {
        SimpleConfiguration config = new FluoConfiguration(params.getConfiguration()).getReporterConfiguration("slf4j");
        if (!config.getBoolean("enable", false)) {
            return Collections.emptyList();
        }
        TimeUnit rateUnit = TimeUnit.valueOf(config.getString("rateUnit", "seconds").toUpperCase());
        TimeUnit durationUnit = TimeUnit.valueOf(config.getString("durationUnit", "milliseconds").toUpperCase());
        Logger logger = LoggerFactory.getLogger((String)config.getString("logger", "metrics"));
        Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)params.getMetricRegistry()).convertDurationsTo(durationUnit).convertRatesTo(rateUnit).outputTo(logger).build();
        reporter.start((long)config.getInt("frequency", 60), TimeUnit.SECONDS);
        log.info("Reporting metrics using slf4j");
        return Collections.singletonList(reporter);
    }
}

