/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.metrics.starters;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.core.metrics.ReporterStarter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxReporterStarter
implements ReporterStarter {
    private static final Logger log = LoggerFactory.getLogger(JmxReporterStarter.class);

    @Override
    public List<AutoCloseable> start(ReporterStarter.Params params) {
        SimpleConfiguration config = new FluoConfiguration(params.getConfiguration()).getReporterConfiguration("jmx");
        if (!config.getBoolean("enable", false)) {
            return Collections.emptyList();
        }
        TimeUnit rateUnit = TimeUnit.valueOf(config.getString("rateUnit", "seconds").toUpperCase());
        TimeUnit durationUnit = TimeUnit.valueOf(config.getString("durationUnit", "milliseconds").toUpperCase());
        JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)params.getMetricRegistry()).convertDurationsTo(durationUnit).convertRatesTo(rateUnit).inDomain(params.getDomain()).build();
        reporter.start();
        log.info("Reporting metrics to JMX");
        return Collections.singletonList(reporter);
    }
}

