/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.metrics.starters;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.core.metrics.ReporterStarter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteReporterStarter
implements ReporterStarter {
    private static final Logger log = LoggerFactory.getLogger(GraphiteReporterStarter.class);

    @Override
    public List<AutoCloseable> start(ReporterStarter.Params params) {
        SimpleConfiguration config = new FluoConfiguration(params.getConfiguration()).getReporterConfiguration("graphite");
        if (!config.getBoolean("enable", false)) {
            return Collections.emptyList();
        }
        String host = config.getString("host");
        String prefix = config.getString("prefix", "");
        int port = config.getInt("port", 8080);
        TimeUnit rateUnit = TimeUnit.valueOf(config.getString("rateUnit", "seconds").toUpperCase());
        TimeUnit durationUnit = TimeUnit.valueOf(config.getString("durationUnit", "milliseconds").toUpperCase());
        Graphite graphite = new Graphite(host, port);
        GraphiteReporter reporter = GraphiteReporter.forRegistry((MetricRegistry)params.getMetricRegistry()).convertDurationsTo(durationUnit).convertRatesTo(rateUnit).prefixedWith(prefix).build(graphite);
        reporter.start((long)config.getInt("frequency", 60), TimeUnit.SECONDS);
        log.info("Reporting metrics to graphite server {}:{}", (Object)host, (Object)port);
        return Collections.singletonList(reporter);
    }
}

