/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.metrics.starters;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.core.metrics.ReporterStarter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvReporterStarter
implements ReporterStarter {
    private static final Logger log = LoggerFactory.getLogger(CsvReporterStarter.class);

    @Override
    public List<AutoCloseable> start(ReporterStarter.Params params) {
        SimpleConfiguration config = new FluoConfiguration(params.getConfiguration()).getReporterConfiguration("csv");
        String dir = config.getString("dir", "");
        if (!config.getBoolean("enable", false) || dir.isEmpty()) {
            return Collections.emptyList();
        }
        TimeUnit rateUnit = TimeUnit.valueOf(config.getString("rateUnit", "seconds").toUpperCase());
        TimeUnit durationUnit = TimeUnit.valueOf(config.getString("durationUnit", "milliseconds").toUpperCase());
        CsvReporter reporter = CsvReporter.forRegistry((MetricRegistry)params.getMetricRegistry()).convertDurationsTo(durationUnit).convertRatesTo(rateUnit).build(new File(dir));
        reporter.start((long)config.getInt("frequency", 60), TimeUnit.SECONDS);
        log.info("Reporting metrics as csv to directory {}", (Object)dir);
        return Collections.singletonList(reporter);
    }
}

