/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.metrics.starters;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.core.metrics.ReporterStarter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleReporterStarter
implements ReporterStarter {
    private static final Logger log = LoggerFactory.getLogger(ConsoleReporterStarter.class);

    @Override
    public List<AutoCloseable> start(ReporterStarter.Params params) {
        SimpleConfiguration config = new FluoConfiguration(params.getConfiguration()).getReporterConfiguration("console");
        if (!config.getBoolean("enable", false)) {
            return Collections.emptyList();
        }
        TimeUnit rateUnit = TimeUnit.valueOf(config.getString("rateUnit", "seconds").toUpperCase());
        TimeUnit durationUnit = TimeUnit.valueOf(config.getString("durationUnit", "milliseconds").toUpperCase());
        PrintStream out = System.out;
        if (config.getString("target", "stdout").equals("stderr")) {
            out = System.err;
        }
        ConsoleReporter reporter = ConsoleReporter.forRegistry((MetricRegistry)params.getMetricRegistry()).convertDurationsTo(durationUnit).convertRatesTo(rateUnit).outputTo(out).build();
        reporter.start((long)config.getInt("frequency", 60), TimeUnit.SECONDS);
        log.info("Reporting metrics to console");
        return Collections.singletonList(reporter);
    }
}

