/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.metrics.ReporterStarter;
import org.mpierce.metrics.reservoir.hdrhistogram.HdrHistogramResetOnSnapshotReservoir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReporterUtil {
    private static final Logger log = LoggerFactory.getLogger(ReporterUtil.class);

    public static AutoCloseable setupReporters(Environment env) {
        return ReporterUtil.setupReporters(env, "fluo");
    }

    public static AutoCloseable setupReporters(final Environment env, final String domain) {
        ServiceLoader<ReporterStarter> serviceLoader = ServiceLoader.load(ReporterStarter.class);
        final ArrayList<AutoCloseable> allReporters = new ArrayList<AutoCloseable>();
        for (ReporterStarter rs : serviceLoader) {
            List<AutoCloseable> reporters = rs.start(new ReporterStarter.Params(){

                @Override
                public SimpleConfiguration getConfiguration() {
                    return env.getConfiguration();
                }

                @Override
                public MetricRegistry getMetricRegistry() {
                    return env.getSharedResources().getMetricRegistry();
                }

                @Override
                public String getDomain() {
                    return domain;
                }
            });
            allReporters.addAll(reporters);
        }
        String hdrSnapshotClass = HdrHistogramResetOnSnapshotReservoir.class.getName();
        String clazz = env.getConfiguration().getString("fluo.impl.metrics.reservoir", hdrSnapshotClass);
        if (allReporters.size() > 1 && clazz.equals(hdrSnapshotClass)) {
            throw new IllegalStateException("Multiple metrics reporters cannot be configured when using " + hdrSnapshotClass + " as corrupt metrics can be reported");
        }
        log.info("Started {} metrics reporters", (Object)allReporters.size());
        return new AutoCloseable(){

            @Override
            public void close() {
                for (AutoCloseable closeable : allReporters) {
                    try {
                        closeable.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }
}

