/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.metrics;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import org.apache.fluo.api.config.FluoConfiguration;
import org.mpierce.metrics.reservoir.hdrhistogram.HdrHistogramResetOnSnapshotReservoir;

public class MetricsUtil {
    public static Reservoir getConfiguredReservoir(FluoConfiguration config) {
        String clazz = config.getString("fluo.impl.metrics.reservoir", HdrHistogramResetOnSnapshotReservoir.class.getName());
        try {
            return Class.forName(clazz).asSubclass(Reservoir.class).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static synchronized Timer addTimer(FluoConfiguration config, MetricRegistry registry, String name) {
        Timer timer = (Timer)registry.getTimers().get(name);
        if (timer == null) {
            timer = new Timer(MetricsUtil.getConfiguredReservoir(config));
            registry.register(name, (Metric)timer);
        }
        return timer;
    }

    public static Timer getTimer(FluoConfiguration config, MetricRegistry registry, String name) {
        Timer timer = (Timer)registry.getTimers().get(name);
        if (timer == null) {
            return MetricsUtil.addTimer(config, registry, name);
        }
        return timer;
    }

    public static synchronized Histogram addHistogram(FluoConfiguration config, MetricRegistry registry, String name) {
        Histogram histogram = (Histogram)registry.getHistograms().get(name);
        if (histogram == null) {
            histogram = new Histogram(MetricsUtil.getConfiguredReservoir(config));
            registry.register(name, (Metric)histogram);
        }
        return histogram;
    }

    public static Histogram getHistogram(FluoConfiguration config, MetricRegistry registry, String name) {
        Histogram histogram = (Histogram)registry.getHistograms().get(name);
        if (histogram == null) {
            return MetricsUtil.addHistogram(config, registry, name);
        }
        return histogram;
    }
}

