/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.metrics;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.metrics.Counter;
import org.apache.fluo.api.metrics.Histogram;
import org.apache.fluo.api.metrics.Meter;
import org.apache.fluo.api.metrics.MetricsReporter;
import org.apache.fluo.api.metrics.Timer;
import org.apache.fluo.core.metrics.MetricsUtil;
import org.apache.fluo.core.metrics.types.CounterImpl;
import org.apache.fluo.core.metrics.types.HistogramImpl;
import org.apache.fluo.core.metrics.types.MeterImpl;
import org.apache.fluo.core.metrics.types.TimerImpl;

public class MetricsReporterImpl
implements MetricsReporter {
    private final FluoConfiguration config;
    private final MetricRegistry registry;
    private final String prefix;

    public MetricsReporterImpl(FluoConfiguration config, MetricRegistry registry, String metricsReporterID) {
        this.config = config;
        this.registry = registry;
        this.prefix = "fluo.app." + metricsReporterID + ".";
    }

    public Counter counter(String metricName) {
        MetricsReporterImpl.validateName(metricName);
        return new CounterImpl(this.registry.counter(this.prefix + metricName));
    }

    public Histogram histogram(String metricName) {
        MetricsReporterImpl.validateName(metricName);
        return new HistogramImpl(MetricsUtil.getHistogram(this.config, this.registry, this.prefix + metricName));
    }

    public Meter meter(String metricName) {
        MetricsReporterImpl.validateName(metricName);
        return new MeterImpl(this.registry.meter(this.prefix + metricName));
    }

    public Timer timer(String metricName) {
        MetricsReporterImpl.validateName(metricName);
        return new TimerImpl(MetricsUtil.getTimer(this.config, this.registry, this.prefix + metricName));
    }

    private static void validateName(String metricName) {
        Objects.requireNonNull(metricName);
        Preconditions.checkArgument((!metricName.contains(".") ? 1 : 0) != 0, (Object)("Metric name " + metricName + " should not contain a period '.'"));
    }
}

