/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.metrics;

import com.google.common.base.Preconditions;

public class MetricNames {
    public static final String METRICS_REPORTER_ID_PROP = "fluo.metrics.reporter.id";
    public static final String CLASS_PREFIX = "fluo.class";
    public static final String SYSTEM_PREFIX = "fluo.system";
    public static final String APPLICATION_PREFIX = "fluo.app";
    private final String txLockWaitTime;
    private final String txExecTime;
    private final String txWithCollision;
    private final String txCollisions;
    private final String txEntriesSet;
    private final String txEntriesRead;
    private final String txLocksTimedOut;
    private final String txLocksDead;
    private final String txStatusPrefix;
    private final String txCommitting;
    private final String notificationsQueued;
    private final String oracleResponseTime;
    private final String oracleClientStamps;
    private final String oracleServerStamps;

    public MetricNames(String metricsReporterId, String appName) {
        Preconditions.checkArgument((!appName.contains(".") ? 1 : 0) != 0, (Object)("Fluo App name should not contain '.': " + appName));
        Preconditions.checkArgument((!metricsReporterId.contains(".") ? 1 : 0) != 0, (Object)("Metrics Reporter ID should not contain '.': " + metricsReporterId));
        String classMetric = "fluo.class." + appName + "." + metricsReporterId + ".";
        this.txLockWaitTime = classMetric + "tx_lock_wait_time";
        this.txExecTime = classMetric + "tx_execution_time";
        this.txWithCollision = classMetric + "tx_with_collision";
        this.txCollisions = classMetric + "tx_collisions";
        this.txEntriesSet = classMetric + "tx_entries_set";
        this.txEntriesRead = classMetric + "tx_entries_read";
        this.txLocksTimedOut = classMetric + "tx_locks_timedout";
        this.txLocksDead = classMetric + "tx_locks_dead";
        this.txStatusPrefix = classMetric + "tx_status_";
        String systemMetric = "fluo.system." + appName + "." + metricsReporterId + ".";
        this.txCommitting = systemMetric + "transactor_committing";
        this.notificationsQueued = systemMetric + "worker_notifications_queued";
        this.oracleResponseTime = systemMetric + "oracle_response_time";
        this.oracleClientStamps = systemMetric + "oracle_client_stamps";
        this.oracleServerStamps = systemMetric + "oracle_server_stamps";
    }

    public String getTxLockWaitTime(String className) {
        return this.txLockWaitTime + "." + className;
    }

    public String getTxExecTime(String className) {
        return this.txExecTime + "." + className;
    }

    public String getTxWithCollision(String className) {
        return this.txWithCollision + "." + className;
    }

    public String getTxCollisions(String className) {
        return this.txCollisions + "." + className;
    }

    public String getTxEntriesSet(String className) {
        return this.txEntriesSet + "." + className;
    }

    public String getTxEntriesRead(String className) {
        return this.txEntriesRead + "." + className;
    }

    public String getTxLocksTimedout(String className) {
        return this.txLocksTimedOut + "." + className;
    }

    public String getTxLocksDead(String className) {
        return this.txLocksDead + "." + className;
    }

    public String getTxStatus(String status, String className) {
        return this.txStatusPrefix + status + "." + className;
    }

    public String getNotificationQueued() {
        return this.notificationsQueued;
    }

    public String getOracleResponseTime() {
        return this.oracleResponseTime;
    }

    public String getOracleClientStamps() {
        return this.oracleClientStamps;
    }

    public String getOracleServerStamps() {
        return this.oracleServerStamps;
    }

    public String getCommitsProcessing() {
        return this.txCommitting;
    }
}

