/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.log;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.fluo.api.client.AbstractTransactionBase;
import org.apache.fluo.api.client.Snapshot;
import org.apache.fluo.api.client.scanner.ScannerBuilder;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.RowColumn;
import org.apache.fluo.api.exceptions.AlreadySetException;
import org.apache.fluo.api.exceptions.CommitException;
import org.apache.fluo.core.async.AsyncCommitObserver;
import org.apache.fluo.core.async.AsyncTransaction;
import org.apache.fluo.core.impl.Notification;
import org.apache.fluo.core.impl.TxStats;
import org.apache.fluo.core.util.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingTransaction
extends AbstractTransactionBase
implements AsyncTransaction,
Snapshot {
    private static final Logger log = LoggerFactory.getLogger((String)"fluo.tx");
    private static final Logger collisionLog = LoggerFactory.getLogger((String)"fluo.tx.collisions");
    private static final Logger summaryLog = LoggerFactory.getLogger((String)"fluo.tx.summary");
    private final AsyncTransaction tx;
    private final long txid;
    private Notification notification;
    private Class<?> clazz;
    private boolean committed = false;

    private static String enc(Bytes b) {
        return Hex.encNonAscii(b);
    }

    private static String enc(Column c) {
        return Hex.encNonAscii(c);
    }

    public TracingTransaction(AsyncTransaction tx) {
        this(tx, null, null);
    }

    public TracingTransaction(AsyncTransaction tx, Class<?> clazz) {
        this(tx, null, clazz);
    }

    private String encB(Collection<Bytes> columns) {
        return Iterators.toString((Iterator)Iterators.transform(columns.iterator(), Hex::encNonAscii));
    }

    private String encRC(Collection<RowColumn> ret) {
        return Iterators.toString((Iterator)Iterators.transform(ret.iterator(), Hex::encNonAscii));
    }

    private String encRC(Map<Bytes, Map<Column, Bytes>> ret) {
        return Iterators.toString((Iterator)Iterators.transform(ret.entrySet().iterator(), e -> TracingTransaction.enc((Bytes)e.getKey()) + "=" + this.encC((Map)e.getValue())));
    }

    private String encRCM(Map<RowColumn, Bytes> ret) {
        return Iterators.toString((Iterator)Iterators.transform(ret.entrySet().iterator(), e -> Hex.encNonAscii((RowColumn)e.getKey()) + "=" + TracingTransaction.enc((Bytes)e.getValue())));
    }

    private String encC(Collection<Column> columns) {
        return Iterators.toString((Iterator)Iterators.transform(columns.iterator(), Hex::encNonAscii));
    }

    private String encC(Map<Column, Bytes> ret) {
        return Iterators.toString((Iterator)Iterators.transform(ret.entrySet().iterator(), e -> TracingTransaction.enc((Column)e.getKey()) + "=" + TracingTransaction.enc((Bytes)e.getValue())));
    }

    public TracingTransaction(AsyncTransaction tx, Notification notification, Class<?> clazz) {
        this.tx = tx;
        this.txid = tx.getStartTimestamp();
        this.notification = notification;
        this.clazz = clazz;
        if (log.isTraceEnabled()) {
            log.trace("txid: {} begin() thread: {}", (Object)this.txid, (Object)Thread.currentThread().getId());
            if (notification != null) {
                log.trace("txid: {} trigger: {} {} {}", new Object[]{this.txid, TracingTransaction.enc(notification.getRow()), TracingTransaction.enc(notification.getColumn()), notification.getTimestamp()});
            }
            if (clazz != null) {
                log.trace("txid: {} class: {}", (Object)this.txid, (Object)clazz.getName());
            }
        }
    }

    public Bytes get(Bytes row, Column column) {
        Bytes ret = this.tx.get(row, column);
        if (log.isTraceEnabled()) {
            log.trace("txid: {} get({}, {}) -> {}", new Object[]{this.txid, TracingTransaction.enc(row), TracingTransaction.enc(column), TracingTransaction.enc(ret)});
        }
        return ret;
    }

    public Map<Column, Bytes> get(Bytes row, Set<Column> columns) {
        Map ret = this.tx.get(row, columns);
        if (log.isTraceEnabled()) {
            log.trace("txid: {} get({}, {}) -> {}", new Object[]{this.txid, TracingTransaction.enc(row), this.encC(columns), this.encC(ret)});
        }
        return ret;
    }

    public Map<Bytes, Map<Column, Bytes>> get(Collection<Bytes> rows, Set<Column> columns) {
        Map ret = this.tx.get(rows, columns);
        if (log.isTraceEnabled()) {
            log.trace("txid: {} get({}, {}) -> {}", new Object[]{this.txid, this.encB(rows), this.encC(columns), this.encRC(ret)});
        }
        return ret;
    }

    public Map<RowColumn, Bytes> get(Collection<RowColumn> rowColumns) {
        Map ret = this.tx.get(rowColumns);
        if (log.isTraceEnabled()) {
            log.trace("txid: {} get({}) -> {}", new Object[]{this.txid, this.encRC(rowColumns), this.encRCM(ret)});
        }
        return ret;
    }

    public ScannerBuilder scanner() {
        log.trace("txid: {} newScanner()", (Object)this.txid);
        return this.tx.scanner();
    }

    public void setWeakNotification(Bytes row, Column col) {
        if (log.isTraceEnabled()) {
            log.trace("txid: {} setWeakNotification({}, {})", new Object[]{this.txid, TracingTransaction.enc(row), TracingTransaction.enc(col)});
        }
        this.tx.setWeakNotification(row, col);
    }

    public void set(Bytes row, Column col, Bytes value) throws AlreadySetException {
        if (log.isTraceEnabled()) {
            log.trace("txid: {} set({}, {}, {})", new Object[]{this.txid, TracingTransaction.enc(row), TracingTransaction.enc(col), TracingTransaction.enc(value)});
        }
        this.tx.set(row, col, value);
    }

    public void delete(Bytes row, Column col) throws AlreadySetException {
        if (log.isTraceEnabled()) {
            log.trace("txid: {} delete({}, {})", new Object[]{this.txid, TracingTransaction.enc(row), TracingTransaction.enc(col)});
        }
        this.tx.delete(row, col);
    }

    public void commit() throws CommitException {
        try {
            this.tx.commit();
            this.committed = true;
            log.trace("txid: {} commit() -> SUCCESSFUL commitTs: {}", (Object)this.txid, (Object)this.tx.getStats().getCommitTs());
        }
        catch (CommitException ce) {
            this.logUnsuccessfulCommit();
            throw ce;
        }
    }

    private void logUnsuccessfulCommit() {
        log.trace("txid: {} commit() -> UNSUCCESSFUL commitTs: {}", (Object)this.txid, (Object)this.tx.getStats().getCommitTs());
        if (!log.isTraceEnabled() && this.notification != null) {
            collisionLog.trace("txid: {} trigger: {} {} {}", new Object[]{this.txid, this.notification.getRow(), this.notification.getColumn(), this.notification.getTimestamp()});
        }
        if (!log.isTraceEnabled() && this.clazz != null) {
            collisionLog.trace("txid: {} class: {}", (Object)this.txid, (Object)this.clazz.getName());
        }
        collisionLog.trace("txid: {} collisions: {}", (Object)this.txid, this.tx.getStats().getRejected());
    }

    public void close() {
        log.trace("txid: {} close()", (Object)this.txid);
        if (summaryLog.isTraceEnabled()) {
            TxStats stats = this.tx.getStats();
            String className = "N/A";
            if (this.clazz != null) {
                className = this.clazz.getSimpleName();
            }
            summaryLog.trace("txid: {} thread : {} time: {} ({} {}) #ret: {} #set: {} #collisions: {} waitTime: {} committed: {} class: {}", new Object[]{this.txid, Thread.currentThread().getId(), stats.getTime(), stats.getReadTime(), stats.getCommitTime(), stats.getEntriesReturned(), stats.getEntriesSet(), stats.getCollisions(), stats.getLockWaitTime(), this.committed, className});
        }
        this.tx.close();
    }

    public static boolean isTracingEnabled() {
        return log.isTraceEnabled() || summaryLog.isTraceEnabled() || collisionLog.isTraceEnabled();
    }

    public long getStartTimestamp() {
        return this.tx.getStartTimestamp();
    }

    @Override
    public void commitAsync(AsyncCommitObserver commitCallback) {
        this.tx.commitAsync(new LoggingCommitObserver(commitCallback));
    }

    @Override
    public TxStats getStats() {
        return this.tx.getStats();
    }

    @Override
    public int getSize() {
        return this.tx.getSize();
    }

    public class LoggingCommitObserver
    implements AsyncCommitObserver {
        AsyncCommitObserver aco;

        LoggingCommitObserver(AsyncCommitObserver aco) {
            this.aco = aco;
        }

        @Override
        public void committed() {
            log.trace("txid: {} commit() -> SUCCESSFUL commitTs: {}", (Object)TracingTransaction.this.txid, (Object)TracingTransaction.this.tx.getStats().getCommitTs());
            TracingTransaction.this.committed = true;
            this.aco.committed();
        }

        @Override
        public void failed(Throwable t) {
            this.aco.failed(t);
            log.trace("txid: {} failed {}", (Object)TracingTransaction.this.txid, (Object)t.getMessage());
        }

        @Override
        public void alreadyAcknowledged() {
            this.aco.alreadyAcknowledged();
            TracingTransaction.this.logUnsuccessfulCommit();
        }

        @Override
        public void commitFailed() {
            this.aco.commitFailed();
            TracingTransaction.this.logUnsuccessfulCommit();
        }
    }
}

