/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl.scanner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.fluo.api.client.scanner.CellScanner;
import org.apache.fluo.api.client.scanner.RowScanner;
import org.apache.fluo.api.client.scanner.RowScannerBuilder;
import org.apache.fluo.api.client.scanner.ScannerBuilder;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.Span;
import org.apache.fluo.core.impl.SnapshotScanner;
import org.apache.fluo.core.impl.TransactionImpl;
import org.apache.fluo.core.impl.scanner.CellScannerImpl;
import org.apache.fluo.core.impl.scanner.RowScannerImpl;

public class ScannerBuilderImpl
implements ScannerBuilder {
    private static final Span EMPTY_SPAN = new Span();
    private TransactionImpl tx;
    private Span span = EMPTY_SPAN;
    private Collection<Column> columns = Collections.emptyList();

    public ScannerBuilderImpl(TransactionImpl tx) {
        this.tx = tx;
    }

    public ScannerBuilder over(Span span) {
        Objects.requireNonNull(span);
        this.span = span;
        return this;
    }

    private void setColumns(Collection<Column> columns) {
        for (Column column : columns) {
            Preconditions.checkArgument((!column.isVisibilitySet() ? 1 : 0) != 0, (Object)"Fetching visibility is not currently supported");
        }
        this.columns = columns;
    }

    public ScannerBuilder fetch(Collection<Column> columns) {
        Objects.requireNonNull(columns);
        this.setColumns((Collection<Column>)ImmutableSet.copyOf(columns));
        return this;
    }

    public ScannerBuilder fetch(Column ... columns) {
        Objects.requireNonNull(columns);
        this.setColumns((Collection<Column>)ImmutableSet.copyOf((Object[])columns));
        return this;
    }

    public CellScanner build() {
        SnapshotScanner snapScanner = this.tx.newSnapshotScanner(this.span, this.columns);
        return new CellScannerImpl(snapScanner);
    }

    public RowScannerBuilder byRow() {
        return new RowScannerBuilder(){

            public RowScanner build() {
                SnapshotScanner snapScanner = ScannerBuilderImpl.this.tx.newSnapshotScanner(ScannerBuilderImpl.this.span, ScannerBuilderImpl.this.columns);
                return new RowScannerImpl(snapScanner);
            }
        };
    }
}

