/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl.scanner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.fluo.api.client.scanner.ColumnScanner;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.ColumnValue;
import org.apache.fluo.core.util.ByteUtil;

public class ColumnScannerImpl
implements ColumnScanner {
    private PeekingIterator<Map.Entry<Key, Value>> peekingIter;
    private Bytes row;
    private Iterator<ColumnValue> iter;
    private boolean gotIter = false;

    public static ColumnValue entry2cv(Map.Entry<Key, Value> entry) {
        Bytes cf = ByteUtil.toBytes(entry.getKey().getColumnFamilyData());
        Bytes cq = ByteUtil.toBytes(entry.getKey().getColumnQualifierData());
        Bytes cv = ByteUtil.toBytes(entry.getKey().getColumnVisibilityData());
        Column col = new Column(cf, cq, cv);
        Bytes val = Bytes.of((byte[])entry.getValue().get());
        return new ColumnValue(col, val);
    }

    ColumnScannerImpl(Iterator<Map.Entry<Key, Value>> e) {
        this.peekingIter = Iterators.peekingIterator(e);
        this.row = ByteUtil.toBytes(((Key)((Map.Entry)this.peekingIter.peek()).getKey()).getRowData());
        this.iter = Iterators.transform(this.peekingIter, ColumnScannerImpl::entry2cv);
    }

    public Iterator<ColumnValue> iterator() {
        Preconditions.checkState((!this.gotIter ? 1 : 0) != 0, (Object)"Unfortunately this implementation only support getting the iterator once");
        this.gotIter = true;
        return this.iter;
    }

    public Bytes getRow() {
        return this.row;
    }

    public String getsRow() {
        return this.getRow().toString();
    }
}

