/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl.scanner;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.fluo.api.client.scanner.CellScanner;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.RowColumnValue;
import org.apache.fluo.core.util.ByteUtil;

public class CellScannerImpl
implements CellScanner {
    private Iterable<Map.Entry<Key, Value>> snapshot;

    private static RowColumnValue entry2rcv(Map.Entry<Key, Value> entry) {
        Bytes row = ByteUtil.toBytes(entry.getKey().getRowData());
        Bytes cf = ByteUtil.toBytes(entry.getKey().getColumnFamilyData());
        Bytes cq = ByteUtil.toBytes(entry.getKey().getColumnQualifierData());
        Bytes cv = ByteUtil.toBytes(entry.getKey().getColumnVisibilityData());
        Column col = new Column(cf, cq, cv);
        Bytes val = Bytes.of((byte[])entry.getValue().get());
        return new RowColumnValue(row, col, val);
    }

    CellScannerImpl(Iterable<Map.Entry<Key, Value>> snapshot) {
        this.snapshot = snapshot;
    }

    public Iterator<RowColumnValue> iterator() {
        return Iterators.transform(this.snapshot.iterator(), CellScannerImpl::entry2rcv);
    }
}

