/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.core.util.ByteUtil;

public class VisibilityCache {
    public static final ColumnVisibility EMPTY_VIS = new ColumnVisibility();
    private final Cache<Bytes, ColumnVisibility> visCache = CacheBuilder.newBuilder().expireAfterAccess(1440L, TimeUnit.MINUTES).maximumWeight(10000000L).weigher((Weigher)new VisWeigher()).concurrencyLevel(10).build();

    VisibilityCache() {
    }

    public ColumnVisibility getCV(Column col) {
        return this.getCV(col.getVisibility());
    }

    public ColumnVisibility getCV(final Bytes colvis) {
        if (colvis.length() == 0) {
            return EMPTY_VIS;
        }
        try {
            return (ColumnVisibility)this.visCache.get((Object)colvis, (Callable)new Callable<ColumnVisibility>(){

                @Override
                public ColumnVisibility call() throws Exception {
                    return new ColumnVisibility(ByteUtil.toText(colvis));
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void validate(Column col) {
        this.getCV(col.getVisibility());
    }

    public void validate(Set<Column> columns) {
        for (Column column : columns) {
            this.validate(column);
        }
    }

    private static class VisWeigher
    implements Weigher<Bytes, ColumnVisibility> {
        private VisWeigher() {
        }

        public int weigh(Bytes key, ColumnVisibility vis) {
            return key.length() + vis.getExpression().length + 32;
        }
    }
}

