/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.metrics.MetricNames;
import org.apache.fluo.core.metrics.MetricsUtil;

public class TxStats {
    private final long startTime;
    private long beginCommitTime;
    private long finishCommitTime;
    private long lockWaitTime = 0L;
    private long entriesReturned = 0L;
    private long entriesSet = 0L;
    private long collisions = -1L;
    private long recovered = 0L;
    private long deadLocks = 0L;
    private long timedOutLocks = 0L;
    private Map<Bytes, Set<Column>> rejected = Collections.emptyMap();
    private long commitTs = -1L;
    private final Environment env;

    TxStats(Environment env) {
        this.startTime = System.currentTimeMillis();
        this.env = env;
    }

    public long getLockWaitTime() {
        return this.lockWaitTime;
    }

    public long getEntriesReturned() {
        return this.entriesReturned;
    }

    public long getEntriesSet() {
        return this.entriesSet;
    }

    public long getTime() {
        return this.finishCommitTime - this.startTime;
    }

    public long getReadTime() {
        return this.beginCommitTime - this.startTime;
    }

    public long getCommitTime() {
        return this.finishCommitTime - this.beginCommitTime;
    }

    public long getCollisions() {
        if (this.collisions == -1L) {
            this.collisions = 0L;
            for (Set<Column> cols : this.rejected.values()) {
                this.collisions += (long)cols.size();
            }
        }
        return this.collisions;
    }

    public long getRecovered() {
        return this.recovered;
    }

    public long getDeadLocks() {
        return this.deadLocks;
    }

    public long getTimedOutLocks() {
        return this.timedOutLocks;
    }

    public Map<Bytes, Set<Column>> getRejected() {
        return this.rejected;
    }

    public long getCommitTs() {
        return this.commitTs;
    }

    public void setCommitTs(long ts) {
        this.commitTs = ts;
    }

    void incrementLockWaitTime(long l) {
        this.lockWaitTime += l;
    }

    void incrementEntriesReturned(long l) {
        this.entriesReturned += l;
    }

    void incrementEntriesSet(long l) {
        this.entriesSet += l;
    }

    void incrementCollisions(long c) {
        this.collisions += c;
    }

    public void setRejected(Map<Bytes, Set<Column>> rejected) {
        Objects.requireNonNull(rejected);
        Preconditions.checkState((this.rejected.size() == 0 ? 1 : 0) != 0);
        this.rejected = rejected;
        this.collisions = -1L;
    }

    void incrementDeadLocks() {
        ++this.deadLocks;
    }

    void incrementTimedOutLocks() {
        ++this.timedOutLocks;
    }

    void incrementTimedOutLocks(int amt) {
        this.timedOutLocks += (long)amt;
    }

    public void report(String status, Class<?> execClass) {
        MetricNames names = this.env.getMetricNames();
        MetricRegistry registry = this.env.getSharedResources().getMetricRegistry();
        String sn = execClass.getSimpleName();
        if (this.getLockWaitTime() > 0L) {
            MetricsUtil.getTimer(this.env.getConfiguration(), registry, names.getTxLockWaitTime(sn)).update(this.getLockWaitTime(), TimeUnit.MILLISECONDS);
        }
        MetricsUtil.getTimer(this.env.getConfiguration(), registry, names.getTxExecTime(sn)).update(this.getReadTime(), TimeUnit.MILLISECONDS);
        if (this.getCollisions() > 0L) {
            registry.meter(names.getTxWithCollision(sn)).mark();
            registry.meter(names.getTxCollisions(sn)).mark(this.getCollisions());
        }
        registry.meter(names.getTxEntriesSet(sn)).mark(this.getEntriesSet());
        registry.meter(names.getTxEntriesRead(sn)).mark(this.getEntriesReturned());
        if (this.getTimedOutLocks() > 0L) {
            registry.meter(names.getTxLocksTimedout(sn)).mark(this.getTimedOutLocks());
        }
        if (this.getDeadLocks() > 0L) {
            registry.meter(names.getTxLocksDead(sn)).mark(this.getDeadLocks());
        }
        registry.meter(names.getTxStatus(status.toLowerCase(), sn)).mark();
    }

    public void setCommitBeginTime(long t) {
        this.beginCommitTime = t;
    }

    public void setCommitFinishTime(long t) {
        this.finishCommitTime = t;
    }
}

