/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import java.util.concurrent.TimeUnit;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.impl.PrimaryRowColumn;
import org.apache.fluo.core.impl.TxInfo;
import org.apache.fluo.core.impl.TxStatus;

public class TxInfoCache {
    static final int CACHE_TIMEOUT_MIN = 1440;
    private final Cache<PrimaryRowColumn, TxInfo> cache = CacheBuilder.newBuilder().expireAfterAccess(1440L, TimeUnit.MINUTES).maximumWeight(10000000L).weigher((Weigher)new TxStatusWeigher()).concurrencyLevel(10).build();
    private final Environment env;

    TxInfoCache(Environment env) {
        this.env = env;
    }

    public TxInfo getTransactionInfo(Bytes prow, Column pcol, long startTs) {
        return this.getTransactionInfo(new PrimaryRowColumn(prow, pcol, startTs));
    }

    public TxInfo getTransactionInfo(PrimaryRowColumn key) {
        TxInfo txInfo = (TxInfo)this.cache.getIfPresent((Object)key);
        if (txInfo == null) {
            txInfo = TxInfo.getTransactionInfo(this.env, key.prow, key.pcol, key.startTs);
            if (txInfo.status == TxStatus.ROLLED_BACK || txInfo.status == TxStatus.COMMITTED) {
                this.cache.put((Object)key, (Object)txInfo);
            }
        }
        return txInfo;
    }

    private static class TxStatusWeigher
    implements Weigher<PrimaryRowColumn, TxInfo> {
        private TxStatusWeigher() {
        }

        public int weigh(PrimaryRowColumn key, TxInfo value) {
            return key.weight() + (value.lockValue == null ? 0 : value.lockValue.length) + 24;
        }
    }
}

