/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.fluo.accumulo.iterators.RollbackCheckIterator;
import org.apache.fluo.accumulo.values.DelLockValue;
import org.apache.fluo.accumulo.values.WriteValue;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.impl.TxStatus;
import org.apache.fluo.core.util.ColumnUtil;

public class TxInfo {
    public TxStatus status = null;
    public long commitTs = -1L;
    public byte[] lockValue = null;

    public static TxInfo getTransactionInfo(Environment env, Bytes prow, Column pcol, long startTs) {
        IteratorSetting is = new IteratorSetting(10, RollbackCheckIterator.class);
        RollbackCheckIterator.setLocktime((IteratorSetting)is, (long)startTs);
        Map.Entry<Key, Value> entry = ColumnUtil.checkColumn(env, is, prow, pcol);
        TxInfo txInfo = new TxInfo();
        if (entry == null) {
            txInfo.status = TxStatus.UNKNOWN;
            return txInfo;
        }
        long colType = entry.getKey().getTimestamp() & 0xE000000000000000L;
        long ts = entry.getKey().getTimestamp() & 0x1FFFFFFFFFFFFFFFL;
        if (colType == -2305843009213693952L) {
            if (ts == startTs) {
                txInfo.status = TxStatus.LOCKED;
                txInfo.lockValue = entry.getValue().get();
            } else {
                txInfo.status = TxStatus.UNKNOWN;
            }
        } else if (colType == 0x2000000000000000L) {
            DelLockValue dlv = new DelLockValue(entry.getValue().get());
            if (ts != startTs) {
                throw new IllegalStateException(prow + " " + pcol + " (" + ts + " != " + startTs + ") ");
            }
            if (dlv.isRollback()) {
                txInfo.status = TxStatus.ROLLED_BACK;
            } else {
                txInfo.status = TxStatus.COMMITTED;
                txInfo.commitTs = dlv.getCommitTimestamp();
            }
        } else if (colType == 0x4000000000000000L) {
            long timePtr = WriteValue.getTimestamp((byte[])entry.getValue().get());
            if (timePtr != startTs) {
                throw new IllegalStateException(prow + " " + pcol + " (" + timePtr + " != " + startTs + ") ");
            }
            txInfo.status = TxStatus.COMMITTED;
            txInfo.commitTs = ts;
        } else {
            throw new IllegalStateException("unexpected col type returned " + colType);
        }
        return txInfo;
    }
}

