/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.curator.framework.recipes.nodes.PersistentEphemeralNode;
import org.apache.fluo.accumulo.util.LongUtil;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.impl.TransactorID;
import org.apache.fluo.core.util.CuratorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactorNode
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TransactorNode.class);
    private Environment env;
    private PersistentEphemeralNode node;
    private TransactorID tid;
    private TrStatus status;

    public TransactorNode(Environment env, TransactorID tid) {
        this.env = env;
        this.tid = tid;
        this.node = new PersistentEphemeralNode(env.getSharedResources().getCurator(), PersistentEphemeralNode.Mode.EPHEMERAL, this.getNodePath(), tid.toString().getBytes());
        CuratorUtil.startAndWait(this.node, 10);
        this.status = TrStatus.OPEN;
    }

    public TransactorNode(Environment env) {
        this(env, new TransactorID(env));
    }

    public TrStatus getStatus() {
        return this.status;
    }

    public TransactorID getTransactorID() {
        if (this.getStatus() == TrStatus.CLOSED) {
            throw new IllegalStateException("TransactorID is closed!");
        }
        return this.tid;
    }

    @Override
    public void close() {
        this.status = TrStatus.CLOSED;
        try {
            this.node.close();
        }
        catch (IOException e) {
            log.error("Failed to close ephemeral node");
            throw new IllegalStateException(e);
        }
    }

    @VisibleForTesting
    public String getNodePath() {
        return TransactorNode.getNodePath(this.env, this.tid.getLongID());
    }

    public static String getNodePath(Environment env, Long transactorId) {
        return "/transactor/nodes/" + LongUtil.toMaxRadixString((Long)transactorId);
    }

    public static enum TrStatus {
        OPEN,
        CLOSED;

    }
}

