/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import java.util.Objects;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.fluo.accumulo.util.LongUtil;
import org.apache.fluo.core.impl.Environment;

public class TransactorID {
    private final Long id;

    public TransactorID(CuratorFramework curator) {
        Objects.requireNonNull(curator);
        this.id = TransactorID.createID(curator);
    }

    public TransactorID(Environment env) {
        this(env.getSharedResources().getCurator());
    }

    public Long getLongID() {
        return this.id;
    }

    public String toString() {
        return LongUtil.toMaxRadixString((Long)this.getLongID());
    }

    private static Long createID(CuratorFramework curator) {
        try {
            DistributedAtomicLong counter = new DistributedAtomicLong(curator, "/transactor/count", (RetryPolicy)new ExponentialBackoffRetry(1000, 10));
            AtomicValue nextId = counter.increment();
            while (!nextId.succeeded()) {
                nextId = counter.increment();
            }
            return (Long)nextId.postValue();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

